// This file has been generated for component class com.sonicsw.mf.framework.directory.DSComponent (102)
// Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.runtime;

/**
 * Remote interface to a runtime instance of a DirectoryService.
 * <p>
 * Management attributes and operations are documented in this interface.
 * <p>
 * An implementation of this interface can be created using the <a href="./MFProxyFactory.html#createDirectoryServiceProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient, javax.management.ObjectName)">MFProxyFactory</a> class.
 * Each implementation instance is valid for the life of the provided <a href="../../../../../com/sonicsw/mf/jmx/client/JMSConnectorClient.html">JMS/JMX Connector</a> and MBean <a href="../../../../../javax/management/ObjectName.html">ObjectName</a>.
 * The implementation is built using remote JMX MBeanServer calls.
 * <p>
 * For each JMX MBean attribute, this interface provides an associated <b>get</b> method (for readable attributes) and/or a <b>set</b> method (for writable attributes).
 * <p>
 * For each JMX MBean operation, this interface provides an associated method with a signature as described by the MBean's <a href="../../../../../javax/management/MBeanOperationInfo.html">operation meta-data</a>.
 * Each JMX MBean operation has an associated impact:
 * <ul>
 * <li>ACTION - Indicates that the operation is a write-like, and would modify the MBean in some way, typically by writing some value or changing a configuration.
 * <li>INFO - Indicates that the operation is read-like, it basically returns information.
 * <li>ACTION/INFO - Indicates that the operation is both read-like and write-like.
 * <li>UNKNOWN - Indicates that the operation has an "unknown" nature.
 * </ul>
 * <p>
 * All exceptions emitted by implementations are wrapped as a <a href="../../../../../com/sonicsw/mf/mgmtapi/runtime/ProxyRuntimeException.html">ProxyRuntimeException</a>.
 * <dl>
 *   <dt><b>See Also:</b></dt>
 *   <dd>
 *     <a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html">DirectoryService Notifications</a>,
 *   </dd>
 * </dl>
 */
public interface IDirectoryServiceProxy
{
    //
    // Useful constants
    //

    /**
     * The well known global component identity for this singleton component.
     */
    public static final String GLOBAL_ID = "DIRECTORY SERVICE";

    //
    // Notification type constants
    //

    /**
     * Notification type constant for the notification configuration.storage.Change.
     * <p>
     * Description: Configuration change(s) propagated by the Directory Services.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#configuration.storage.Change"><code>configuration.storage.Change</code></a>
     *   </dd>
     * </dl>
     */
    public static final String CONFIGURATION_STORAGE_CHANGE_NOTIFICATION_ID = "configuration.storage.Change";

    /**
     * Notification type constant for the notification system.security.ConfigurePermissionDenied.
     * <p>
     * Description: Standby container has failed over to become the active container.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#system.security.ConfigurePermissionDenied"><code>system.security.ConfigurePermissionDenied</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_SECURITY_CONFIGUREPERMISSIONDENIED_NOTIFICATION_ID = "system.security.ConfigurePermissionDenied";

    /**
     * Notification type constant for the notification system.state.Failover.
     * <p>
     * Description: Standby service has failed over to become the active service.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#system.state.Failover"><code>system.state.Failover</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_FAILOVER_NOTIFICATION_ID = "system.state.Failover";

    /**
     * Notification type constant for the notification system.state.Offline.
     * <p>
     * Description: Component stop complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_OFFLINE_NOTIFICATION_ID = "system.state.Offline";

    /**
     * Notification type constant for the notification system.state.Online.
     * <p>
     * Description: Component start complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_ONLINE_NOTIFICATION_ID = "system.state.Online";

    //
    // MBean attributes
    //

    /**
     * Gets the values of several attributes of a DirectoryService component.
     * <p>
     * Getting multiple attribute values at once is typically more efficient than getting individual attribute values.
     * <p>
     * Readable attributes (and their datatypes) exposed by a DirectoryService are:
     * <ul>
     * <li><a href="#getAllowFailover()"><code>AllowFailover</code></a> (java.lang.Boolean)
     * <li><a href="#getClassname()"><code>Classname</code></a> (java.lang.String)
     * <li><a href="#getClasspath()"><code>Classpath</code></a> (java.lang.String)
     * <li><a href="#getConfigID()"><code>ConfigID</code></a> (java.lang.String)
     * <li><a href="#getFaultToleranceRole()"><code>FaultToleranceRole</code></a> (java.lang.String)
     * <li><a href="#getFaultTolerantState()"><code>FaultTolerantState</code></a> (java.lang.Short)
     * <li><a href="#getFaultTolerantStateString()"><code>FaultTolerantStateString</code></a> (java.lang.String)
     * <li><a href="#getLastError()"><code>LastError</code></a> (java.lang.String)
     * <li><a href="#getLastErrorLevel()"><code>LastErrorLevel</code></a> (java.lang.Integer)
     * <li><a href="#getLastErrorLevelString()"><code>LastErrorLevelString</code></a> (java.lang.String)
     * <li><a href="#getReleaseVersion()"><code>ReleaseVersion</code></a> (java.lang.String)
     * <li><a href="#getState()"><code>State</code></a> (java.lang.Short)
     * <li><a href="#getStateString()"><code>StateString</code></a> (java.lang.String)
     * <li><a href="#getTraceMask()"><code>TraceMask</code></a> (java.lang.Integer)
     * <li><a href="#getTraceMaskValues()"><code>TraceMaskValues</code></a> (java.lang.String)
     * <li><a href="#getUptime()"><code>Uptime</code></a> (java.lang.Long)
     * </ul>
     * @param attributeNames A list of the attribute names of attributes to be retrieved.
     *
     * @return The list of the retrieved attributes.
     *
     * @see #setAttributes(javax.management.AttributeList)
     */
    public javax.management.AttributeList getAttributes(String[] attributeNames);

    /**
     * Sets the values of several attributes of a DirectoryService component.
     * <p>
     * Setting multiple attribute values at once is typically more efficient than setting individual attribute values.
     * <p>
     * Settable attributes (and their datatypes) exposed by a DirectoryService are:
     * <ul>
     * <li><a href="#setAllowFailover(java.lang.Boolean)"><code>AllowFailover</code></a> (java.lang.Boolean)
     * <li><a href="#setTraceMask(java.lang.Integer)"><code>TraceMask</code></a> (java.lang.Integer)
     * </ul>
     * @param attributes A list of attributes: The identification of the attributes to be set and the values they are to be set to.
     *
     * @return The list of attributes that were set, with their new values.
     *
     * @see #getAttributes(java.lang.String[])
     */
    public javax.management.AttributeList setAttributes(javax.management.AttributeList attributes);

    /**
     * Gets the value of the AllowFailover attribute.
     *
     * @return When this Directory Service is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.
     *
     * @see #setAllowFailover(java.lang.Boolean)
     */
    public java.lang.Boolean getAllowFailover();

    /**
     * Sets the value of the AllowFailover attribute.
     *
     * @param value When this Directory Service is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.
     *
     * @see #getAllowFailover()
     */
    public void setAllowFailover(java.lang.Boolean value);

    /**
     * Gets the value of the Classname attribute.
     *
     * @return Component classname.
     */
    public java.lang.String getClassname();

    /**
     * Gets the value of the Classpath attribute.
     *
     * @return Component classpath.
     */
    public java.lang.String getClasspath();

    /**
     * Gets the value of the ConfigID attribute.
     *
     * @return Configuration identity.
     */
    public java.lang.String getConfigID();

    /**
     * Gets the value of the FaultToleranceRole attribute.
     *
     * @return The fault tolerant role of the DS (primary or backup) or null if not fault tolerant.
     */
    public java.lang.String getFaultToleranceRole();

    /**
     * Gets the value of the FaultTolerantState attribute.
     *
     * @return The current fault tolerant state of this Directory Service.
     */
    public java.lang.Short getFaultTolerantState();

    /**
     * Gets the value of the FaultTolerantStateString attribute.
     *
     * @return The description of the current fault tolerant state of this Directory Service.
     */
    public java.lang.String getFaultTolerantStateString();

    /**
     * Gets the value of the LastError attribute.
     *
     * @return Last (uncleared) error condition.
     */
    public java.lang.String getLastError();

    /**
     * Gets the value of the LastErrorLevel attribute.
     *
     * @return Last (uncleared) error severity.
     */
    public java.lang.Integer getLastErrorLevel();

    /**
     * Gets the value of the LastErrorLevelString attribute.
     *
     * @return Last (uncleared) error severity description.
     */
    public java.lang.String getLastErrorLevelString();

    /**
     * Gets the value of the ReleaseVersion attribute.
     *
     * @return Component release version.
     */
    public java.lang.String getReleaseVersion();

    /**
     * Gets the value of the State attribute.
     *
     * @return Execution state of the component.
     *
     * @see #getStateString()
     * @see com.sonicsw.mf.common.runtime.IComponentState
     */
    public java.lang.Short getState();

    /**
     * Gets the value of the StateString attribute.
     *
     * @return Description of the execution state of the component.
     *
     * @see #getState()
     * @see com.sonicsw.mf.common.runtime.IComponentState#STATE_TEXT
     */
    public java.lang.String getStateString();

    /**
     * Gets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - startup
     * <li>32 - updates
     * <li>64 - pass
     * <li>128 - container access
     * <li>256 - configuration notifications
     * <li>512 - validation triggers
     * <li>1024 - all directory service access
     * <li>2048 - fault detection
     * </ul>
     *
     * @return Debug bit mask.
     *
     * @see #setTraceMask(java.lang.Integer)
     * @see #getTraceMaskValues()
     */
    public java.lang.Integer getTraceMask();

    /**
     * Sets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - startup
     * <li>32 - updates
     * <li>64 - pass
     * <li>128 - container access
     * <li>256 - configuration notifications
     * <li>512 - validation triggers
     * <li>1024 - all directory service access
     * <li>2048 - fault detection
     * </ul>
     *
     * @param value Debug bit mask.
     *
     * @see #getTraceMask()
     * @see #getTraceMaskValues()
     */
    public void setTraceMask(java.lang.Integer value);

    /**
     * Gets the value of the TraceMaskValues attribute.
     *
     * @return Possible TraceMask values.
     *
     * @see #getTraceMask()
     * @see #setTraceMask(java.lang.Integer)
     */
    public java.lang.String getTraceMaskValues();

    /**
     * Gets the value of the Uptime attribute.
     *
     * @return Execution time (milliseconds).
     */
    public java.lang.Long getUptime();

    //
    // MBean operations
    //

    /**
     * Invokes the clearError operation.
     * <p>
     * Clear existing error condition.
     * <p>
     * Impact: ACTION
     * @see #getLastErrorLevel()
     */
    public void clearError();

    /**
     * Invokes the getBackupStatus operation.
     * <p>
     * Return a BackupStatus object with information about the last backup
     * <p>
     * Impact: INFO
     */
    public com.sonicsw.mf.common.runtime.IBackupStatus getBackupStatus();
    
    /**
     * Invokes the getDirectoryServiceVersion operation.
     * <p>
     * Gets the Directory Service version.
     * <p>
     * Impact: INFO
     */
    public java.lang.Integer getDirectoryServiceVersion();

    /**
     * Invokes the getDomain operation.
     * <p>
     * Gets the domain name for the configuration domain the Directory Service maintains.
     * <p>
     * Impact: INFO
     */
    public java.lang.String getDomain();

    /**
     * Invokes the leaseLock operation.
     * <p>
     * Leases the named lock against the given key for the given period. Returns true if the the lock was successfully acquired, false if not.
     * <p>
     * Impact: ACTION
     *
     * @param lockName The name of the lock to be acquired.
     * @param key The key under which the lock (if acquired) should be held.
     * @param leaseDuration The duration the lock lease will remain in effect (cannot be (re)acquired using a different key). After the duration has expired the lock can be acquired under a different key.
     */
    public java.lang.Boolean leaseLock(java.lang.String lockName, java.lang.String key, java.lang.Integer leaseDuration);

 
    /**
     * Invokes the listExternalDomainWithManagementSPI operation.
     * <p>
     * Return list of external domain descriptors that have been configured with Management SPI.
     * <p>
     * Impact: INFO
     */
    public java.lang.String[] listExternalDomainWithManagementSPI();

    /**
     * Invokes the releaseLock operation.
     * <p>
     * Releases a previously acquired lock (if that lock is still held against the given key).
     * <p>
     * Impact: ACTION
     *
     * @param lockName The name of the acquired lock.
     * @param key The key under which the lock was acquired.
     */
    public void releaseLock(java.lang.String lockName, java.lang.String key);

    /**
     * Invokes the reloadExternalAuthenticationDomain operation.
     * <p>
     * Reloads the external domain that matches the descriptor passed in.
     * <p>
     * Impact: ACTION
     *
     * @param mfDomainDescriptor The name of the external domain
     */
    public java.lang.Boolean reloadExternalAuthenticationDomain(java.lang.String mfDomainDescriptor);

    /**
     * Invokes the start operation.
     * <p>
     * Start providing service.
     * <p>
     * Impact: ACTION
     * @see #stop()
     */
    public void start();

    /**
     * Invokes the startBackup operation.
     * <p>
     * Start the backup process asynchronously
     * <p>
     * Impact: ACTION
     *
     * @param backupDir The directory to use for the backup
     * @param overwrite Overwrite the existing DS if there is one in the backup directory
     */
    public void startBackup(java.lang.String backupDir, java.lang.Boolean overwrite);

    /**
     * Invokes the stop operation.
     * <p>
     * Stop providing service.
     * <p>
     * Impact: ACTION
     * @see #start()
     */
    public void stop();

    //
    // MBean notifications
    //

    /**
     * Adds a notification listener.
     * <p>
     * A DirectoryService component publishes the following notifications:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#configuration.storage.Change"><code>configuration.storage.Change</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#system.security.ConfigurePermissionDenied"><code>system.security.ConfigurePermissionDenied</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#system.state.Failover"><code>system.state.Failover</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/DirectoryServiceNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     * </ul>
     * @param listener The listener object which will handle the notifications emitted component.
     * @param filter The filter object. If filter is null, no filtering will be performed before handling notifications.
     * @param handback The context to be sent to the listener when a notification is emitted.
     *
     * @see #removeNotificationListener(javax.management.NotificationListener)
     */
    public void addNotificationListener(javax.management.NotificationListener listener, javax.management.NotificationFilter filter, Object handback);

    /**
     * Removes a notification listener.
     * <p>
     * This method will remove all the information related to the given listener.
     * @param listener The listener object which will handle the notifications emitted by the registered MBean.
     *
     * @see #addNotificationListener(javax.management.NotificationListener, javax.management.NotificationFilter, Object)
     */
    public void removeNotificationListener(javax.management.NotificationListener listener);
}
