// This file has been generated for component class com.sonicsw.mf.framework.logger.LoggerComponent (105)
// Copyright (c) 2002-2007 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.runtime;

/**
 * Remote interface to a runtime instance of a Logger.
 * <p>
 * Management attributes and operations are documented in this interface.
 * <p>
 * An implementation of this interface can be created using the <a href="./MFProxyFactory.html#createLoggerProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient, javax.management.ObjectName)">MFProxyFactory</a> class.
 * Each implementation instance is valid for the life of the provided <a href="../../../../../com/sonicsw/mf/jmx/client/JMSConnectorClient.html">JMS/JMX Connector</a> and MBean <a href="../../../../../javax/management/ObjectName.html">ObjectName</a>.
 * The implementation is built using remote JMX MBeanServer calls.
 * <p>
 * For each JMX MBean attribute, this interface provides an associated <b>get</b> method (for readable attributes) and/or a <b>set</b> method (for writable attributes).
 * <p>
 * For each JMX MBean operation, this interface provides an associated method with a signature as described by the MBean's <a href="../../../../../javax/management/MBeanOperationInfo.html">operation meta-data</a>.
 * Each JMX MBean operation has an associated impact:
 * <ul>
 * <li>ACTION - Indicates that the operation is a write-like, and would modify the MBean in some way, typically by writing some value or changing a configuration.
 * <li>INFO - Indicates that the operation is read-like, it basically returns information.
 * <li>ACTION/INFO - Indicates that the operation is both read-like and write-like.
 * <li>UNKNOWN - Indicates that the operation has an "unknown" nature.
 * </ul>
 * <p>
 * All exceptions emitted by implementations are wrapped as a <a href="../../../../../com/sonicsw/mf/mgmtapi/runtime/ProxyRuntimeException.html">ProxyRuntimeException</a>.
 * <dl>
 *   <dt><b>See Also:</b></dt>
 *   <dd>
 *     <a href="../../../../../../mgmt_monitoring/LoggerNotifications.html">Logger Notifications</a>,
 *     <a href="../../../../../../mgmt_monitoring/LoggerMetrics.html">Logger Metrics</a>
 *   </dd>
 * </dl>
 */
public interface ILoggerProxy
{
    //
    // Notification type constants
    //

    /**
     * Notification type constant for the notification application.alert.logger.metrics.LoggedPerMinute.
     * <p>
     * Description: Alert for metric logger.metrics.LoggedPerMinute
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/LoggerNotifications.html#application.alert.logger.metrics.LoggedPerMinute"><code>application.alert.logger.metrics.LoggedPerMinute</code></a>
     *   </dd>
     * </dl>
     */
    public static final String APPLICATION_ALERT_LOGGER_METRICS_LOGGEDPERMINUTE_NOTIFICATION_ID = "application.alert.logger.metrics.LoggedPerMinute";

    /**
     * Notification type constant for the notification application.alert.logger.notifications.LoggedPerMinute.
     * <p>
     * Description: Alert for metric logger.notifications.LoggedPerMinute
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/LoggerNotifications.html#application.alert.logger.notifications.LoggedPerMinute"><code>application.alert.logger.notifications.LoggedPerMinute</code></a>
     *   </dd>
     * </dl>
     */
    public static final String APPLICATION_ALERT_LOGGER_NOTIFICATIONS_LOGGEDPERMINUTE_NOTIFICATION_ID = "application.alert.logger.notifications.LoggedPerMinute";

    /**
     * Notification type constant for the notification system.state.Offline.
     * <p>
     * Description: Component stop complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/LoggerNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_OFFLINE_NOTIFICATION_ID = "system.state.Offline";

    /**
     * Notification type constant for the notification system.state.Online.
     * <p>
     * Description: Component start complete.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/LoggerNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     *   </dd>
     * </dl>
     */
    public static final String SYSTEM_STATE_ONLINE_NOTIFICATION_ID = "system.state.Online";

    //
    // Metric indentity constants
    //

    /**
     * Metric identity constant for the metric logger.metrics.LoggedPerMinute.
     * <p>
     * Description: Rate at which metrics have been logged.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.metrics.LoggedPerMinute"><code>logger.metrics.LoggedPerMinute</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity LOGGER_METRICS_LOGGEDPERMINUTE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "logger",
        "metrics",
        "LoggedPerMinute"
    });

    /**
     * Metric identity constant for the metric logger.notifications.LoggedPerMinute.
     * <p>
     * Description: Rate at which notifications have been logged.
     * <dl>
     *  <dt><b>See Also:</b></dt>
     *   <dd>
     *    <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.notifications.LoggedPerMinute"><code>logger.notifications.LoggedPerMinute</code></a>
     *   </dd>
     * </dl>
     */
    public static final com.sonicsw.mf.common.metrics.IMetricIdentity LOGGER_NOTIFICATIONS_LOGGEDPERMINUTE_METRIC_ID = com.sonicsw.mf.common.metrics.MetricsFactory.createMetricIdentity(new String[]
    {
        "logger",
        "notifications",
        "LoggedPerMinute"
    });

    //
    // MBean attributes
    //

    /**
     * Gets the values of several attributes of a Logger component.
     * <p>
     * Getting multiple attribute values at once is typically more efficient than getting individual attribute values.
     * <p>
     * Readable attributes (and their datatypes) exposed by a Logger are:
     * <ul>
     * <li><a href="#getClassname()"><code>Classname</code></a> (java.lang.String)
     * <li><a href="#getClasspath()"><code>Classpath</code></a> (java.lang.String)
     * <li><a href="#getCollectionsMonitorPollInterval()"><code>CollectionsMonitorPollInterval</code></a> (java.lang.Integer)
     * <li><a href="#getCollectionsMonitorRuntimeID()"><code>CollectionsMonitorRuntimeID</code></a> (java.lang.String)
     * <li><a href="#getComponentCollections()"><code>ComponentCollections</code></a> (java.lang.String[])
     * <li><a href="#getConfigID()"><code>ConfigID</code></a> (java.lang.String)
     * <li><a href="#getControlNumber()"><code>ControlNumber</code></a> (java.lang.String)
     * <li><a href="#getEvaluationMode()"><code>EvaluationMode</code></a> (java.lang.Boolean)
     * <li><a href="#getLastError()"><code>LastError</code></a> (java.lang.String)
     * <li><a href="#getLastErrorLevel()"><code>LastErrorLevel</code></a> (java.lang.Integer)
     * <li><a href="#getLastErrorLevelString()"><code>LastErrorLevelString</code></a> (java.lang.String)
     * <li><a href="#getLog4jConfigurationFilePath()"><code>Log4jConfigurationFilePath</code></a> (java.lang.String)
     * <li><a href="#getLogFormat()"><code>LogFormat</code></a> (java.lang.String)
     * <li><a href="#getLogTextDelimiter()"><code>LogTextDelimiter</code></a> (java.lang.String)
     * <li><a href="#getMaxLookbackPeriod()"><code>MaxLookbackPeriod</code></a> (java.lang.Integer)
     * <li><a href="#getMetricsCollectionInterval()"><code>MetricsCollectionInterval</code></a> (java.lang.Integer)
     * <li><a href="#getMetricsRefreshInterval()"><code>MetricsRefreshInterval</code></a> (java.lang.Integer)
     * <li><a href="#getReleaseVersion()"><code>ReleaseVersion</code></a> (java.lang.String)
     * <li><a href="#getRepeatMetricAlerts()"><code>RepeatMetricAlerts</code></a> (java.lang.Boolean)
     * <li><a href="#getState()"><code>State</code></a> (java.lang.Short)
     * <li><a href="#getStateString()"><code>StateString</code></a> (java.lang.String)
     * <li><a href="#getTraceMask()"><code>TraceMask</code></a> (java.lang.Integer)
     * <li><a href="#getTraceMaskValues()"><code>TraceMaskValues</code></a> (java.lang.String)
     * <li><a href="#getUptime()"><code>Uptime</code></a> (java.lang.Long)
     * </ul>
     * @param attributeNames A list of the attribute names of attributes to be retrieved.
     *
     * @return The list of the retrieved attributes.
     *
     * @see #setAttributes(javax.management.AttributeList)
     */
    public javax.management.AttributeList getAttributes(String[] attributeNames);

    /**
     * Sets the values of several attributes of a Logger component.
     * <p>
     * Setting multiple attribute values at once is typically more efficient than setting individual attribute values.
     * <p>
     * Settable attributes (and their datatypes) exposed by a Logger are:
     * <ul>
     * <li><a href="#setCollectionsMonitorPollInterval(java.lang.Integer)"><code>CollectionsMonitorPollInterval</code></a> (java.lang.Integer)
     * <li><a href="#setCollectionsMonitorRuntimeID(java.lang.String)"><code>CollectionsMonitorRuntimeID</code></a> (java.lang.String)
     * <li><a href="#setComponentCollections(java.lang.String[])"><code>ComponentCollections</code></a> (java.lang.String[])
     * <li><a href="#setControlNumber(java.lang.String)"><code>ControlNumber</code></a> (java.lang.String)
     * <li><a href="#setEvaluationMode(java.lang.Boolean)"><code>EvaluationMode</code></a> (java.lang.Boolean)
     * <li><a href="#setLog4jConfigurationFilePath(java.lang.String)"><code>Log4jConfigurationFilePath</code></a> (java.lang.String)
     * <li><a href="#setLogFormat(java.lang.String)"><code>LogFormat</code></a> (java.lang.String)
     * <li><a href="#setLogTextDelimiter(java.lang.String)"><code>LogTextDelimiter</code></a> (java.lang.String)
     * <li><a href="#setMaxLookbackPeriod(java.lang.Integer)"><code>MaxLookbackPeriod</code></a> (java.lang.Integer)
     * <li><a href="#setMetricsCollectionInterval(java.lang.Integer)"><code>MetricsCollectionInterval</code></a> (java.lang.Integer)
     * <li><a href="#setMetricsRefreshInterval(java.lang.Integer)"><code>MetricsRefreshInterval</code></a> (java.lang.Integer)
     * <li><a href="#setRepeatMetricAlerts(java.lang.Boolean)"><code>RepeatMetricAlerts</code></a> (java.lang.Boolean)
     * <li><a href="#setTraceMask(java.lang.Integer)"><code>TraceMask</code></a> (java.lang.Integer)
     * </ul>
     * @param attributes A list of attributes: The identification of the attributes to be set and the values they are to be set to.
     *
     * @return The list of attributes that were set, with their new values.
     *
     * @see #getAttributes(java.lang.String[])
     */
    public javax.management.AttributeList setAttributes(javax.management.AttributeList attributes);

    /**
     * Gets the value of the Classname attribute.
     *
     * @return Component classname.
     */
    public java.lang.String getClassname();

    /**
     * Gets the value of the Classpath attribute.
     *
     * @return Component classpath.
     */
    public java.lang.String getClasspath();

    /**
     * Gets the value of the CollectionsMonitorPollInterval attribute.
     *
     * @return The amount of time that the LoggerComponent instance will wait between attempts to poll its associated CollectionMonitor for metrics and notifications data.
     *
     * @see #setCollectionsMonitorPollInterval(java.lang.Integer)
     */
    public java.lang.Integer getCollectionsMonitorPollInterval();

    /**
     * Sets the value of the CollectionsMonitorPollInterval attribute.
     *
     * @param value The amount of time that the LoggerComponent instance will wait between attempts to poll its associated CollectionMonitor for metrics and notifications data.
     *
     * @see #getCollectionsMonitorPollInterval()
     */
    public void setCollectionsMonitorPollInterval(java.lang.Integer value);

    /**
     * Gets the value of the CollectionsMonitorRuntimeID attribute.
     *
     * @return The runtime ID of the CollectionsMonitor with which this LoggerComponent instance is associated.
     *
     * @see #setCollectionsMonitorRuntimeID(java.lang.String)
     */
    public java.lang.String getCollectionsMonitorRuntimeID();

    /**
     * Sets the value of the CollectionsMonitorRuntimeID attribute.
     *
     * @param value The runtime ID of the CollectionsMonitor with which this LoggerComponent instance is associated.
     *
     * @see #getCollectionsMonitorRuntimeID()
     */
    public void setCollectionsMonitorRuntimeID(java.lang.String value);

    /**
     * Gets the value of the ComponentCollections attribute.
     *
     * @return IDs of Component Collections in which this LoggerComponent is interested.
     *
     * @see #setComponentCollections(java.lang.String[])
     */
    public java.lang.String[] getComponentCollections();

    /**
     * Sets the value of the ComponentCollections attribute.
     *
     * @param value IDs of Component Collections in which this LoggerComponent is interested.
     *
     * @see #getComponentCollections()
     */
    public void setComponentCollections(java.lang.String[] value);

    /**
     * Gets the value of the ConfigID attribute.
     *
     * @return Configuration identity.
     */
    public java.lang.String getConfigID();

    /**
     * Gets the value of the ControlNumber attribute.
     *
     * @return The LoggerComponent License Control Number [required in order to access Logger functionality].
     *
     * @see #setControlNumber(java.lang.String)
     */
    public java.lang.String getControlNumber();

    /**
     * Sets the value of the ControlNumber attribute.
     *
     * @param value The LoggerComponent License Control Number [required in order to access Logger functionality].
     *
     * @see #getControlNumber()
     */
    public void setControlNumber(java.lang.String value);

    /**
     * Gets the value of the EvaluationMode attribute.
     *
     * @return Flag that indicates if LoggerComponent is running in evaluation-only mode [limited time use].
     *
     * @see #setEvaluationMode(java.lang.Boolean)
     */
    public java.lang.Boolean getEvaluationMode();

    /**
     * Sets the value of the EvaluationMode attribute.
     *
     * @param value Flag that indicates if LoggerComponent is running in evaluation-only mode [limited time use].
     *
     * @see #getEvaluationMode()
     */
    public void setEvaluationMode(java.lang.Boolean value);

    /**
     * Gets the value of the LastError attribute.
     *
     * @return Last (uncleared) error condition.
     */
    public java.lang.String getLastError();

    /**
     * Gets the value of the LastErrorLevel attribute.
     *
     * @return Last (uncleared) error severity.
     */
    public java.lang.Integer getLastErrorLevel();

    /**
     * Gets the value of the LastErrorLevelString attribute.
     *
     * @return Last (uncleared) error severity description.
     */
    public java.lang.String getLastErrorLevelString();

    /**
     * Gets the value of the Log4jConfigurationFilePath attribute.
     *
     * @return Path to log4j configuration file.
     *
     * @see #setLog4jConfigurationFilePath(java.lang.String)
     */
    public java.lang.String getLog4jConfigurationFilePath();

    /**
     * Sets the value of the Log4jConfigurationFilePath attribute.
     *
     * @param value Path to log4j configuration file.
     *
     * @see #getLog4jConfigurationFilePath()
     */
    public void setLog4jConfigurationFilePath(java.lang.String value);

    /**
     * Gets the value of the LogFormat attribute.
     *
     * @return Format used to log data [Delimited Text, XML, or Java Object format].
     *
     * @see #setLogFormat(java.lang.String)
     */
    public java.lang.String getLogFormat();

    /**
     * Sets the value of the LogFormat attribute.
     *
     * @param value Format used to log data [Delimited Text, XML, or Java Object format].
     *
     * @see #getLogFormat()
     */
    public void setLogFormat(java.lang.String value);

    /**
     * Gets the value of the LogTextDelimiter attribute.
     *
     * @return Character [or text] used to delimit log entries [applicable only when using the Delimited Text log format].
     *
     * @see #setLogTextDelimiter(java.lang.String)
     */
    public java.lang.String getLogTextDelimiter();

    /**
     * Sets the value of the LogTextDelimiter attribute.
     *
     * @param value Character [or text] used to delimit log entries [applicable only when using the Delimited Text log format].
     *
     * @see #getLogTextDelimiter()
     */
    public void setLogTextDelimiter(java.lang.String value);

    /**
     * Gets the value of the MaxLookbackPeriod attribute.
     *
     * @return The maximum number of threads that the Agent Manager can create to poll containers for their state.
     *
     * @see #setMaxLookbackPeriod(java.lang.Integer)
     */
    public java.lang.Integer getMaxLookbackPeriod();

    /**
     * Sets the value of the MaxLookbackPeriod attribute.
     *
     * @param value The maximum number of threads that the Agent Manager can create to poll containers for their state.
     *
     * @see #getMaxLookbackPeriod()
     */
    public void setMaxLookbackPeriod(java.lang.Integer value);

    /**
     * Gets the value of the MetricsCollectionInterval attribute.
     *
     * @return Metrics collection interval (in minutes)
     *
     * @see #setMetricsCollectionInterval(java.lang.Integer)
     */
    public java.lang.Integer getMetricsCollectionInterval();

    /**
     * Sets the value of the MetricsCollectionInterval attribute.
     *
     * @param value Metrics collection interval (in minutes)
     *
     * @see #getMetricsCollectionInterval()
     */
    public void setMetricsCollectionInterval(java.lang.Integer value);

    /**
     * Gets the value of the MetricsRefreshInterval attribute.
     *
     * @return Metrics refresh interval (in seconds)
     *
     * @see #setMetricsRefreshInterval(java.lang.Integer)
     */
    public java.lang.Integer getMetricsRefreshInterval();

    /**
     * Sets the value of the MetricsRefreshInterval attribute.
     *
     * @param value Metrics refresh interval (in seconds)
     *
     * @see #getMetricsRefreshInterval()
     */
    public void setMetricsRefreshInterval(java.lang.Integer value);

    /**
     * Gets the value of the ReleaseVersion attribute.
     *
     * @return Component release version.
     */
    public java.lang.String getReleaseVersion();

    /**
     * Gets the value of the RepeatMetricAlerts attribute.
     *
     * @return Repeat metric alert notifications
     *
     * @see #setRepeatMetricAlerts(java.lang.Boolean)
     */
    public java.lang.Boolean getRepeatMetricAlerts();

    /**
     * Sets the value of the RepeatMetricAlerts attribute.
     *
     * @param value Repeat metric alert notifications
     *
     * @see #getRepeatMetricAlerts()
     */
    public void setRepeatMetricAlerts(java.lang.Boolean value);

    /**
     * Gets the value of the State attribute.
     *
     * @return Execution state of the component.
     *
     * @see #getStateString()
     * @see com.sonicsw.mf.common.runtime.IComponentState
     */
    public java.lang.Short getState();

    /**
     * Gets the value of the StateString attribute.
     *
     * @return Description of the execution state of the component.
     *
     * @see #getState()
     * @see com.sonicsw.mf.common.runtime.IComponentState#STATE_TEXT
     */
    public java.lang.String getStateString();

    /**
     * Gets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - logger failures
     * <li>32 - logger exceptions
     * <li>64 - logger invocations
     * <li>128 - logging cycle
     * </ul>
     *
     * @return Debug bit mask.
     *
     * @see #setTraceMask(java.lang.Integer)
     * @see #getTraceMaskValues()
     */
    public java.lang.Integer getTraceMask();

    /**
     * Sets the value of the TraceMask attribute.
     *
     * The trace mask is a bit mask composed from the following possible values:
     * <ul>
     * <li>1 - verbose
     * <li>2 - set attributes
     * <li>4 - operation invoked
     * <li>8 - notification sent
     * <li>16 - logger failures
     * <li>32 - logger exceptions
     * <li>64 - logger invocations
     * <li>128 - logging cycle
     * </ul>
     *
     * @param value Debug bit mask.
     *
     * @see #getTraceMask()
     * @see #getTraceMaskValues()
     */
    public void setTraceMask(java.lang.Integer value);

    /**
     * Gets the value of the TraceMaskValues attribute.
     *
     * @return Possible TraceMask values.
     *
     * @see #getTraceMask()
     * @see #setTraceMask(java.lang.Integer)
     */
    public java.lang.String getTraceMaskValues();

    /**
     * Gets the value of the Uptime attribute.
     *
     * @return Execution time (milliseconds).
     */
    public java.lang.Long getUptime();

    //
    // MBean operations
    //

    /**
     * Invokes the addComponentCollectionID operation.
     * <p>
     * Adds a Component Collection ID to the list of Component Collections in which the LoggerComponent is currently interested.
     * <p>
     * Impact: ACTION
     *
     * @param componentCollectionID The ID of a Component Collection to be added to the list of Component Collections in which the LoggerComponent is currently interested.
     */
    public void addComponentCollectionID(java.lang.String[] componentCollectionID);

    /**
     * Invokes the clearError operation.
     * <p>
     * Clear existing error condition.
     * <p>
     * Impact: ACTION
     * @see #getLastErrorLevel()
     */
    public void clearError();

    /**
     * Invokes the disableAlerts operation.
     * <p>
     * Disable threshold alerts on a metric.
     * <p>
     * Impact: ACTION
     * <p>
     * Metrics that allow alert thresholds to be specified are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.metrics.LoggedPerMinute"><code>logger.metrics.LoggedPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.notifications.LoggedPerMinute"><code>logger.notifications.LoggedPerMinute</code></a>
     * </ul>
     *
     * @param alerts A list of alerts to disable.
     *
     * @see #enableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     */
    public void disableAlerts(com.sonicsw.mf.common.metrics.IAlert[] alerts);

    /**
     * Invokes the disableMetrics operation.
     * <p>
     * Disable the given set of dynamic metrics.
     * <p>
     * Impact: ACTION
     * <p>
     * Dynamic metrics are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.metrics.LoggedPerMinute"><code>logger.metrics.LoggedPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.notifications.LoggedPerMinute"><code>logger.notifications.LoggedPerMinute</code></a>
     * </ul>
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public void disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the enableAlerts operation.
     * <p>
     * Enable threshold alerts on a metric.
     * <p>
     * Impact: ACTION
     * <p>
     * Metrics that allow alert thresholds to be specified are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.metrics.LoggedPerMinute"><code>logger.metrics.LoggedPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.notifications.LoggedPerMinute"><code>logger.notifications.LoggedPerMinute</code></a>
     * </ul>
     *
     * @param alerts A list of alerts to enable.
     *
     * @see #disableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     */
    public void enableAlerts(com.sonicsw.mf.common.metrics.IAlert[] alerts);

    /**
     * Invokes the enableMetrics operation.
     * <p>
     * Enable the given set of dynamic metrics.
     * <p>
     * Impact: ACTION
     * <p>
     * Dynamic metrics are:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.metrics.LoggedPerMinute"><code>logger.metrics.LoggedPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerMetrics.html#logger.notifications.LoggedPerMinute"><code>logger.notifications.LoggedPerMinute</code></a>
     * </ul>
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public void enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getActiveMetrics operation.
     * <p>
     * Gets the the list of metrics currently active in this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identity patterns.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricIdentity[] getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getEnabledAlerts operation.
     * <p>
     * Get all metric threshold alerts enabled by this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identities for which to get the enabled alerts.
     *
     * @see #disableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     * @see #enableAlerts(com.sonicsw.mf.common.metrics.IAlert[])
     */
    public com.sonicsw.mf.common.metrics.IAlert[] getEnabledAlerts(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getEnabledMetrics operation.
     * <p>
     * Get the list of metric patterns that have been enabled for this component.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of metrics identities for which to get the enabled alerts.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricIdentity[] getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids);

    /**
     * Invokes the getMetricsData operation.
     * <p>
     * Gets metric values for a given set of metrics. If a requested metric was not enabled or is otherwise unknown, then no data for that metric will be included in the results.
     * <p>
     * Impact: INFO
     *
     * @param ids A list of active metrics, either individual metrics or instances.
     * @param returnTriggeredAlerts If true, each metric returned should include a list of triggered (exceeded) alerts for these metrics.
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsInfo()
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricsData getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[] ids, java.lang.Boolean returnTriggeredAlerts);

    /**
     * Invokes the getMetricsInfo operation.
     * <p>
     * Gets the meta-data for all metrics supported by this component.
     * <p>
     * Impact: INFO
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #resetMetrics()
     */
    public com.sonicsw.mf.common.metrics.IMetricInfo[] getMetricsInfo();

    /**
     * Invokes the reload operation.
     * <p>
     * Asynchronously reload the component and restart the component if it was previously online.
     * <p>
     * Impact: ACTION
     */
    public void reload();

    /**
     * Invokes the removeComponentCollectionID operation.
     * <p>
     * Removes a Component Collection ID from the list of Component Collections in which the LoggerComponent is currently interested. A return value of "false" indicates that the attempt was unsuccessful [A LoggerComponent must always be configured with at least one Component Collection ID, and an attempt to remove the only remaining ID will fail].
     * <p>
     * Impact: ACTION
     *
     * @param componentCollectionID The ID of a Component Collection to be removed from the list of Component Collections in which the LoggerComponent is currently interested.
     */
    public java.lang.Boolean removeComponentCollectionID(java.lang.String[] componentCollectionID);

    /**
     * Invokes the resetMetrics operation.
     * <p>
     * Reset all metrics to their initial state.
     * <p>
     * Impact: ACTION
     *
     * @see #disableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #enableMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getActiveMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getEnabledMetrics(com.sonicsw.mf.common.metrics.IMetricIdentity[])
     * @see #getMetricsData(com.sonicsw.mf.common.metrics.IMetricIdentity[], java.lang.Boolean)
     * @see #getMetricsInfo()
     */
    public void resetMetrics();

    /**
     * Invokes the start operation.
     * <p>
     * Start providing service.
     * <p>
     * Impact: ACTION
     * @see #stop()
     */
    public void start();

    /**
     * Invokes the stop operation.
     * <p>
     * Stop providing service.
     * <p>
     * Impact: ACTION
     * @see #start()
     */
    public void stop();

    //
    // MBean notifications
    //

    /**
     * Adds a notification listener.
     * <p>
     * A Logger component publishes the following notifications:
     * <ul>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerNotifications.html#application.alert.logger.metrics.LoggedPerMinute"><code>application.alert.logger.metrics.LoggedPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerNotifications.html#application.alert.logger.notifications.LoggedPerMinute"><code>application.alert.logger.notifications.LoggedPerMinute</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerNotifications.html#system.state.Offline"><code>system.state.Offline</code></a>
     * <li><a href="../../../../../../mgmt_monitoring/LoggerNotifications.html#system.state.Online"><code>system.state.Online</code></a>
     * </ul>
     * @param listener The listener object which will handle the notifications emitted component.
     * @param filter The filter object. If filter is null, no filtering will be performed before handling notifications.
     * @param handback The context to be sent to the listener when a notification is emitted.
     *
     * @see #removeNotificationListener(javax.management.NotificationListener)
     */
    public void addNotificationListener(javax.management.NotificationListener listener, javax.management.NotificationFilter filter, Object handback);

    /**
     * Removes a notification listener.
     * <p>
     * This method will remove all the information related to the given listener.
     * @param listener The listener object which will handle the notifications emitted by the registered MBean.
     *
     * @see #addNotificationListener(javax.management.NotificationListener, javax.management.NotificationFilter, Object)
     */
    public void removeNotificationListener(javax.management.NotificationListener listener);
}
