// This file has been generated for proxy interfaces found in the com.sonicsw.mf.mgmtapi.runtime package.
// Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.

package com.sonicsw.mf.mgmtapi.runtime;

/**
 * Provides factory methods to create a runtime proxies that remotely interact with the management API of Sonic MBeans.
 */
public final class MFProxyFactory
{
    private MFProxyFactory() { }
    //
    // Proxy factory methods
    //

    /**
     * Creates a runtime proxy to remotely interact with the management API of an ActivationDaemon MBean.
     *
     * @param connector The JMS/JMX connector to be used for communications.
     * @param objectName The JMX ObjectName of the ActivationDaemon MBean.
     *
     * @return An ActivationDaemon proxy.
     */
    public static IActivationDaemonProxy createActivationDaemonProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient connector, javax.management.ObjectName objectName)
    {
        return new com.sonicsw.mf.mgmtapi.runtime.impl.ActivationDaemonProxy(connector, objectName);
    }

    /**
     * Creates a runtime proxy to remotely interact with the management API of an AgentManager MBean.
     *
     * @param connector The JMS/JMX connector to be used for communications.
     * @param objectName The JMX ObjectName of the AgentManager MBean.
     *
     * @return An AgentManager proxy.
     */
    public static IAgentManagerProxy createAgentManagerProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient connector, javax.management.ObjectName objectName)
    {
        com.sonicsw.mf.common.runtime.impl.CanonicalName canonicalName = new com.sonicsw.mf.common.runtime.impl.CanonicalName(objectName.getCanonicalName());
        if (!canonicalName.getComponentName().equals(IAgentManagerProxy.GLOBAL_ID))
        {
            throw new IllegalArgumentException("ID must equal \"" + IAgentManagerProxy.GLOBAL_ID + "\"");
        }
        return new com.sonicsw.mf.mgmtapi.runtime.impl.AgentManagerProxy(connector, objectName);
    }

    /**
     * Creates a runtime proxy to remotely interact with the management API of an Agent MBean.
     *
     * @param connector The JMS/JMX connector to be used for communications.
     * @param objectName The JMX ObjectName of the Agent MBean.
     *
     * @return An Agent proxy.
     */
    public static IAgentProxy createAgentProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient connector, javax.management.ObjectName objectName)
    {
        com.sonicsw.mf.common.runtime.impl.CanonicalName canonicalName = new com.sonicsw.mf.common.runtime.impl.CanonicalName(objectName.getCanonicalName());
        if (!canonicalName.getComponentName().equals(IAgentProxy.ID))
        {
            throw new IllegalArgumentException("ID must equal \"" + IAgentProxy.ID + "\"");
        }
        return new com.sonicsw.mf.mgmtapi.runtime.impl.AgentProxy(connector, objectName);
    }

    /**
     * Creates a runtime proxy to remotely interact with the management API of a CollectionsMonitor MBean.
     *
     * @param connector The JMS/JMX connector to be used for communications.
     * @param objectName The JMX ObjectName of the CollectionsMonitor MBean.
     *
     * @return A CollectionsMonitor proxy.
     */
    public static ICollectionsMonitorProxy createCollectionsMonitorProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient connector, javax.management.ObjectName objectName)
    {
        return new com.sonicsw.mf.mgmtapi.runtime.impl.CollectionsMonitorProxy(connector, objectName);
    }

    /**
     * Creates a runtime proxy to remotely interact with the management API of a DirectoryService MBean.
     *
     * @param connector The JMS/JMX connector to be used for communications.
     * @param objectName The JMX ObjectName of the DirectoryService MBean.
     *
     * @return A DirectoryService proxy.
     */
    public static IDirectoryServiceProxy createDirectoryServiceProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient connector, javax.management.ObjectName objectName)
    {
        com.sonicsw.mf.common.runtime.impl.CanonicalName canonicalName = new com.sonicsw.mf.common.runtime.impl.CanonicalName(objectName.getCanonicalName());
        if (!canonicalName.getComponentName().equals(IDirectoryServiceProxy.GLOBAL_ID))
        {
            throw new IllegalArgumentException("ID must equal \"" + IDirectoryServiceProxy.GLOBAL_ID + "\"");
        }
        return new com.sonicsw.mf.mgmtapi.runtime.impl.DirectoryServiceProxy(connector, objectName);
    }
   /**
     * Creates a runtime proxy to remotely interact with the management API of a HostManager MBean.
     *
     * @param connector The JMS/JMX connector to be used for communications.
     * @param objectName The JMX ObjectName of the HostManager MBean.
     *
     * @return A HostManager proxy.
     */
    public static IHostManagerProxy createHostManagerProxy(com.sonicsw.mf.jmx.client.JMSConnectorClient connector, javax.management.ObjectName objectName)
    {
        return new com.sonicsw.mf.mgmtapi.runtime.impl.HostManagerProxy(connector, objectName);
    }
}
