package com.sonicsw.mf.mgmtapi.runtime;

import javax.management.JMRuntimeException;

/**
 * Proxy runtime exceptions are used to wrap underlying exceptions propagated from the remote
 * component the proxy represents.
 * <p>
 * Use getTargetException() to get the underlying exception.
 */
public final class ProxyRuntimeException
extends JMRuntimeException
{
    /**
     * Constructs a proxy runtime exception with the given cause exception.
     */
    public ProxyRuntimeException(Exception e)
    {
        super();
        super.initCause(e);
    }

    /**
     * Constructs a proxy runtime exception with the given target cause and message.
     */
    public ProxyRuntimeException(Exception e, String message)
    {
        super(message);
        super.initCause(e);
    }

    /**
     * Gets the underlying (target) exception .. use Thowable.getCause() instead.
     * 
     * @deprecated Replaced by Throwable.getCause()
     */
    public Exception getTargetException() { return (Exception)super.getCause(); }
}