package com.sonicsw.mx.config;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AttributeChangeFilter
implements IConfigChangeFilter
{
    Set m_enabledAttributes = new HashSet();

    @Override
    public boolean
    equals(Object obj)
    {
        if (obj != null && this.getClass() == obj.getClass())
        {
            return m_enabledAttributes.equals(((AttributeChangeFilter)obj).m_enabledAttributes);
        }
        return false;
    }

    @Override
    public int
    hashCode()
    {
        return m_enabledAttributes.hashCode();
    }

    public void
    disableAllAttributes()
    {
        m_enabledAttributes.clear();
    }

    public void
    enableAttribute(IConfigPath attribute)
    {
        m_enabledAttributes.add(attribute);
    }

    public void
    disableAttribute(IConfigPath attribute)
    {
        m_enabledAttributes.remove(attribute);
    }

    public Set
    getEnabledAttributes()
    {
        return m_enabledAttributes;
    }

    @Override
    public boolean
    isConfigChangeEnabled(ConfigChange configChange)
    {
        if (configChange.getChangeType() == ConfigChange.ELEMENT_DELETED)
        {
            return true;
        }
        else
        if (configChange.getChangeType() == ConfigChange.ELEMENT_UPDATED)
        {
            Iterator it = configChange.getDeletedAttributeNames().iterator();
            while (it.hasNext())
            {
                if (m_enabledAttributes.contains(it.next()))
                {
                    return true;
                }
            }
            it = configChange.getModifiedAttributeNames().iterator();
            while (it.hasNext())
            {
                if (m_enabledAttributes.contains(it.next()))
                {
                    return true;
                }
            }
        }
        return false;
    }
}