package com.sonicsw.mx.config;

public class ConfigAttributeException extends ConfigServiceException
{
    public ConfigAttributeException(IConfigPath attributeName, String errorKey, Object[] errorArgs, Exception linkedException)
    {
        super(errorKey, null, linkedException);
        if (errorArgs != null)
        {
            m_errorArgs = new Object [errorArgs.length + 1];
            m_errorArgs[0] = attributeName;
            System.arraycopy(errorArgs, 0, m_errorArgs, 1, errorArgs.length);
        }
        else
        {
            m_errorArgs = new Object[] { attributeName };
        }
    }

    public ConfigAttributeException(IConfigPath attributeName, String errorKey, Object[] errorArgs)
    {
        this(attributeName, errorKey, errorArgs, null);
    }

    public ConfigAttributeException(IConfigPath attributeName, String errorKey, Exception linkedException)
    {
        this (attributeName, errorKey, null, linkedException);
    }

    public ConfigAttributeException(IConfigPath attributeName, String errorMsg)
    {
        this(attributeName, errorMsg, null, null);
    }

    public IConfigPath
    getAttributeName()
    {
        return (IConfigPath) getErrorArgs()[0];
    }

    public void
    setAttributeName(IConfigPath attributeName)
    {
        getErrorArgs()[0] = attributeName;
    }
}