package com.sonicsw.mx.config;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import com.sonicsw.mx.config.impl.ConfigPathImpl;
import com.sonicsw.mx.config.impl.Util;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeList;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementDeleteNotification;
import com.sonicsw.mf.common.config.IFolderCreateNotification;
import com.sonicsw.mf.common.config.IFolderDeleteNotification;
import com.sonicsw.mf.common.config.IMetaAttributesChangeNotification;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.IRenameNotification;

public class ConfigChange extends EventObject
{
    public static final short ELEMENT_ADDED    = IElementChange.ELEMENT_ADDED;
    public static final short ELEMENT_UPDATED  = IElementChange.ELEMENT_UPDATED;
    public static final short ELEMENT_DELETED  = IElementChange.ELEMENT_DELETED;
    public static final short ELEMENT_REPLACED = IElementChange.ELEMENT_REPLACED;
    public static final short FOLDER_ADDED     = ELEMENT_REPLACED + 1;
    public static final short FOLDER_DELETED   = FOLDER_ADDED + 1;
    public static final short RENAME           = FOLDER_DELETED + 1;
    public static final short META_ATTRIBUTES_CHANGE = RENAME + 1;

    protected long m_version = -1;
    protected short m_type;
    protected Object m_handback = null;
    protected Set m_newAttributeNames = new HashSet();
    protected Set m_modifiedAttributeNames = new HashSet();
    protected Set m_deletedAttributeNames = new HashSet();
    protected Map m_metaAttributes = new HashMap();
    protected String m_newName = null;
    protected boolean m_isReleaseVersion = false;

    public ConfigChange(ConfigChange configChange, Object handback)
    {
        super(configChange.source);
        m_version = configChange.m_version;
        m_type = configChange.m_type;
        m_newAttributeNames.addAll(configChange.m_newAttributeNames);
        m_modifiedAttributeNames.addAll(configChange.m_modifiedAttributeNames);
        m_deletedAttributeNames.addAll(configChange.m_deletedAttributeNames);
        m_newName = configChange.m_newName;
        m_metaAttributes.putAll(configChange.m_metaAttributes);
        m_handback = handback;
        m_isReleaseVersion = configChange.m_isReleaseVersion;
    }

    public ConfigChange(IElementChange elementChange, Object handback)
    {
        super(elementChange.getElement().getIdentity().getName());
        m_version = elementChange.getElement().getIdentity().getVersion();
        m_type = elementChange.getChangeType();
        m_handback = handback;
        parseElementChange(elementChange);
    }

    public ConfigChange(String name, long version, short type)
    {
        super(name);
        m_version = version;
        m_type = type;
    }

    public ConfigChange(INamingNotification namingNotification, Object handback)
    throws ConfigServiceException
    {
        super(namingNotification.getName());
        if (namingNotification instanceof IFolderCreateNotification)
        {
            m_type = FOLDER_ADDED;
        }
        else
        if (namingNotification instanceof IFolderDeleteNotification)
        {
            m_type = FOLDER_DELETED;
        }
        else
        if (namingNotification instanceof IRenameNotification)
        {
            m_type = RENAME;
            m_newName = ((IRenameNotification)namingNotification).getNewName();
        }
        else
        if (namingNotification instanceof IMetaAttributesChangeNotification)
        {
            m_type = META_ATTRIBUTES_CHANGE;
            Map ma = ((IMetaAttributesChangeNotification)namingNotification).getAttributes();
            m_metaAttributes.putAll(Util.splitToolMetaAttributes(ma));
        }
        else
        if (namingNotification instanceof IElementDeleteNotification)
        {
            m_type = ELEMENT_DELETED;
        }
        else
        {
            throw new ConfigServiceException("cc-init-unknown-type", new Object[] { namingNotification.getClass().getName() } );
        }


        m_handback = handback;
    }

    protected final void 
    parseElementChange(IElementChange elementChange)
    {
        IBasicElement element = elementChange.getElement();
        if (element instanceof IDeltaElement)
        {
            Object obj = ((IDeltaElement)element).getDeltaAttributes();
            if (obj instanceof IDeltaAttributeSet)
            {
                parseDeltaAttributeSet((IDeltaAttributeSet) obj, new ConfigPathImpl());
            }
            else // obj instanceof IAttributeSet
            {   // Entire attribute set of element has been overwritten:
                // add the names of all attributes in the set to the modified attribute names set.
                System.err.println("Delta element contains attribute set.");
                Iterator names = ((IAttributeSet)obj).getAttributes().keySet().iterator();
                while (names.hasNext())
                {
                    m_modifiedAttributeNames.add(new ConfigPathImpl((String) names.next()));
                }
            }
        }
    }

    protected void
    parseDeltaAttributeSet(IDeltaAttributeSet attrSet, IConfigPath path)
    {
        // Add paths for deleted attributes.
        String[] attrNames = attrSet.getDeletedAttributesNames();
        for(int i = 0; i < attrNames.length; i++)
        {
            m_deletedAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
        }

        // Add paths for new attributes.
        attrNames = attrSet.getNewAttributesNames();
        for(int i = 0; i < attrNames.length; i++)
        {
            Object attrValue = null;
            try
            {
                attrValue = attrSet.getNewValue(attrNames[i]);
            }
            catch (Exception e)
            {
                continue;
            }

            if (attrValue instanceof IDeltaAttributeSet)
            {
                parseDeltaAttributeSet((IDeltaAttributeSet) attrValue, new ConfigPathImpl(path).append(attrNames[i]));
            }
            else if (attrValue instanceof IDeltaAttributeList)
            {
                // REVISIT: For now any change to attribute list is recognized as a
                // change of entire list.
                m_newAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
            }
            else
            {
                // New attribute list, map or atomic value
                if(attrValue instanceof IAttributeSet)
                {
                    Map attributes = ((IAttributeSet)attrValue).getAttributes();
                    if(attributes.size() == 1 && attributes.get("RELEASE_VERSION") != null)
                    {
                        m_isReleaseVersion = true;
                    }
                }
                m_newAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
            }
        }

        // Add paths for modified attributes.
        attrNames = attrSet.getModifiedAttributesNames();
        for(int i = 0; i < attrNames.length; i++)
        {
            Object attrValue = null;
            try
            {
                attrValue = attrSet.getNewValue(attrNames[i]);
            }
            catch (Exception e)
            {
                continue;
            }

            if (attrValue instanceof IDeltaAttributeSet)
            {
                parseDeltaAttributeSet((IDeltaAttributeSet) attrValue, new ConfigPathImpl(path).append(attrNames[i]));
            }
            else if (attrValue instanceof IDeltaAttributeList)
            {
                // REVISIT: For now any change to attribute list is recognized as a
                // change of entire list.
                m_modifiedAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
            }
            else
            {
                // modified attribute list, map or atomic value
                if(attrValue instanceof IAttributeSet)
                {
                    Map attributes = ((IAttributeSet)attrValue).getAttributes();
                    if(attributes.size() == 1 && attributes.get("RELEASE_VERSION") != null)
                    {
                        m_isReleaseVersion = true;
                    }
                }
                m_modifiedAttributeNames.add(new ConfigPathImpl(path).append(attrNames[i]));
            }
        }
    }

    public short getChangeType()
    {
        return m_type;
    }

    public String getName()
    {
        return (String) getSource();
    }

    public String getNewName()
    {
        return m_newName;
    }

    public long getVersion()
    {
        return m_version;
    }

    public Set getNewAttributeNames()
    {
        return m_newAttributeNames;
    }

    public Set getModifiedAttributeNames()
    {
        return m_modifiedAttributeNames;
    }

    public Set getDeletedAttributeNames()
    {
        return m_deletedAttributeNames;
    }

    public Object getHandback()
    {
        return m_handback;
    }

    public Map getMetaAttributes()
    {
        return m_metaAttributes;
    }

    public boolean isReleaseVersion()
    {
        return m_isReleaseVersion;
    }

    @Override
    public String toString()
    {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ConfigChange:\n");
        buffer.append("{\n");
        buffer.append("  Config Element Name:" + getName() + "\n");
        buffer.append("  New Config Element Name:" + getNewName() + "\n");
        buffer.append("  Config Element Version:" + getVersion() + "\n");
        buffer.append("  Type:" + type2String(m_type) + "\n");
        buffer.append("  Handback:" + m_handback + "\n");
        buffer.append("  Is Release Version:" + m_isReleaseVersion + "\n");
        buffer.append("  NewAttributeNames:\n");
        buffer.append("  {\n");
        Iterator it = m_newAttributeNames.iterator();
        while (it.hasNext())
        {
            buffer.append("    ").append(it.next()).append("\n");
        }
        buffer.append("  }\n");

        buffer.append("  ModifiedAttributeNames:\n");
        buffer.append("  {\n");
        it = m_modifiedAttributeNames.iterator();
        while (it.hasNext())
        {
            buffer.append("    ").append(it.next()).append("\n");
        }
        buffer.append("  }\n");

        buffer.append("  DeletedAttributeNames:\n");
        buffer.append("  {\n");
        it = m_deletedAttributeNames.iterator();
        while (it.hasNext())
        {
            buffer.append("    ").append(it.next()).append("\n");
        }
        buffer.append("  }\n");

        buffer.append("  MetaAttributes:\n");
        buffer.append("  {\n");
        it = m_metaAttributes.entrySet().iterator();
        while (it.hasNext())
        {
            Map.Entry entry = (Map.Entry) it.next();
            buffer.append("    ").append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
        buffer.append("  }\n");

        buffer.append("}\n");
        return buffer.toString();
    }

    private String type2String(short type)
    {
        switch (type)
        {
        case ELEMENT_ADDED:
            return "ELEMENT_ADDED";
        case ELEMENT_UPDATED:
            return "ELEMENT_UPDATED";
        case ELEMENT_DELETED:
            return "ELEMENT_DELETED";
        case ELEMENT_REPLACED:
            return "ELEMENT_REPLACED";
        case FOLDER_ADDED:
            return "FOLDER_ADDED";
        case FOLDER_DELETED:
            return "FOLDER_DELETED";
        case META_ATTRIBUTES_CHANGE:
            return "META_ATTRIBUTES_CHANGE";
        case RENAME:
            return "RENAME";
        default:
            return "";
        }
    }
}