/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mx.config;

import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.StringTokenizer;

import com.sonicsw.mx.config.impl.ConfigPathImpl;

public class ConfigFactory
{
    private static long   s_lastTime;
    private static int    s_lastIndex;
    private static String s_ipAddr;
    private static String s_unique;
    private static Object s_lock = new Object();

    public static String
    createGUID()
    {
        synchronized (s_lock)
        {
            if (s_ipAddr == null)
            {
                try
                {
                    StringBuffer ipBuffer = new StringBuffer();

                    byte[] addr = InetAddress.getLocalHost().getAddress();

                    for (int iAddr = 0; iAddr < addr.length; iAddr++)
                    {
                        int x = (int) (addr[iAddr] & 0xFF);

                        if (x < 0x10)
                        {
                            ipBuffer.append("0");
                        }

                        ipBuffer.append(Integer.toString(x, 16).toUpperCase());
                    }
                    s_ipAddr = ipBuffer.toString();
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
                s_unique = Integer.toString((new SecureRandom()).nextInt(0xffff), 16);
            }

            StringBuffer buffer = new StringBuffer(s_ipAddr).append(s_unique);

            long time = System.currentTimeMillis();

            buffer.append(Long.toString(time, 16));

            // put an index on the end based on how many GUIDs have been
            // generated at the sime time
            if (time == s_lastTime)
            {
                s_lastIndex++;
            }
            else
            {
                s_lastTime = time;
                s_lastIndex = 0;
            }
            buffer.append(s_lastIndex);

            return buffer.toString();
        }
    }

    // AJB - this needs to go.
    public static String
    generateDSName(String format)
    {
        StringBuffer buffer = new StringBuffer();
        ArrayList    ids    = new ArrayList();

        StringTokenizer st = new StringTokenizer(format, "{}");

        while(st.hasMoreTokens())
        {
            String token = st.nextToken();

            // try to convert the token to an integer. If it works then
            // assume we want to replace it. This isn't ideal but it will
            // do for now.

            try
            {
                int num = Integer.parseInt(token);

                // check that the number is either one we already have or
                // the next one available
                if(num == ids.size())
                {
                    String newID = ConfigFactory.createGUID();
                    ids.add(newID);
                    buffer.append(newID);
                }
                else if(num < ids.size())
                {
                    buffer.append(ids.get(num));
                }
                else
                {
                    System.out.println("ConfigFactory::generateDSName value " +
                                       num + " is out of sequence");
                    return null;
                }
            }
            catch(NumberFormatException e)
            {
                // it isn't a number so just add it to the output buffer
                buffer.append(token);
            }
        }
        return buffer.toString();
    }

    public static IConfigPath
    createConfigPath()
    {
        return new ConfigPathImpl();
    }

    public static IConfigPath
    createConfigPath(IConfigPath path)
    {
        return new ConfigPathImpl(path);
    }

    public static IConfigPath
    createConfigPath(String path)
    {
        return new ConfigPathImpl(path);
    }

}
