package com.sonicsw.mx.config;

import com.sonicsw.mx.config.util.MessageFormatter;

import com.sonicsw.mf.common.MFException;

public class ConfigServiceException extends MFException
{
    public static final String CONFIG_SERVICE_ERRORS = "com.sonicsw.mx.config.ConfigServiceErrors";

    /**
     * Error Bundle.
     * The resource bundle containing error message.
     */
    protected String m_errorBundle = null;

    /**
     * Error Key.
     * Key is used to lookup error message from resource bundle.
     */
    protected String m_errorKey = null;

    /**
     * Error Arguments.
     * Arguments are used as substitution parameters in error message.
     */
    protected Object[] m_errorArgs = null;

    public ConfigServiceException(String errorBundle, String errorKey, Object[] errorArgs, Exception linkedException)
    {
        m_errorBundle = errorBundle;
        m_errorKey = errorKey;
        m_errorArgs = errorArgs;
        setLinkedException(linkedException);
    }

    public ConfigServiceException(ConfigServiceRuntimeException e)
    {
        this(e.m_errorBundle, e.m_errorKey, e.m_errorArgs, e);
    }

    public ConfigServiceException(String errorKey, Object[] errorArgs, Exception linkedException)
    {
        this(CONFIG_SERVICE_ERRORS, errorKey, errorArgs, linkedException);
    }

    public ConfigServiceException(String errorKey, Object[] errorArgs)
    {
        this(errorKey, errorArgs, null);
    }

    public ConfigServiceException(String errorKey, Exception linkedException)
    {
        this (errorKey, null, linkedException);
    }

    public ConfigServiceException(String errorMsg)
    {
        this(errorMsg, null, null);
    }

    public String
    getErrorKey()
    {
        return m_errorKey;
    }

    public void
    setErrorKey(String errorKey)
    {
        m_errorKey = errorKey;
    }

    public Object[]
    getErrorArgs()
    {
        return m_errorArgs;
    }

    public void
    setErrorArgs(Object[] errorArgs)
    {
        m_errorArgs = errorArgs;
    }

    @Override
    public String getMessage()
    {
        return MessageFormatter.formatMessage(m_errorBundle, m_errorKey, m_errorArgs);
    }

    @Override
    public String toString()
    {
        return getClass().getName() + ": " + getMessage();
    }
}