package com.sonicsw.mx.config;

import com.sonicsw.mx.config.util.MessageFormatter;

public class ConfigServiceRuntimeException extends RuntimeException
{
    public static final String CONFIG_SERVICE_ERRORS = "com.sonicsw.mx.config.ConfigServiceErrors";

    /**
     * Error Bundle.
     * The resource bundle containing error message.
     */
    protected String m_errorBundle = null;

    /**
     * Error Key.
     * Key is used to lookup error message from resource bundle.
     */
    protected String m_errorKey = null;

    /**
     * Error Arguments.
     * Arguments are used as substitution parameters in error message.
     */
    protected Object[] m_errorArgs = null;

    public ConfigServiceRuntimeException(ConfigServiceException e)
    {
        this(e.m_errorBundle, e.m_errorKey, e.m_errorArgs, e);
    }

    public ConfigServiceRuntimeException(String errorBundle, String errorKey, Object[] errorArgs, Exception linkedException)
    {
        super(linkedException);
        m_errorBundle = errorBundle;
        m_errorKey = errorKey;
        m_errorArgs = errorArgs;
    }

    public ConfigServiceRuntimeException(String errorKey, Object[] errorArgs, Exception linkedException)
    {
        this(CONFIG_SERVICE_ERRORS, errorKey, errorArgs, linkedException);
    }

    public ConfigServiceRuntimeException(String errorKey, Object[] errorArgs)
    {
        this(errorKey, errorArgs, null);
    }

    public ConfigServiceRuntimeException(String errorKey, Exception linkedException)
    {
        this (errorKey, null, linkedException);
    }

    public ConfigServiceRuntimeException(String errorMsg)
    {
        this(errorMsg, null, null);
    }

    /**
     * As of Sonic 7.6, setLinkedException() will call initCause().
     * 
     * @deprecated Use Throwable.initCause() instead.
     */
    public void setLinkedException(Exception e)
    {
        super.initCause(e);
    }

    /**
     * As of Sonic 7.6, getLinkedException() will call getCause().
     * 
     * @deprecated Use Throwable.getCause() instead.
     */
    public Exception getLinkedException()
    {
        return (Exception)super.getCause();
    }

    @Override
    public String getMessage()
    {
        return MessageFormatter.formatMessage(m_errorBundle, m_errorKey, m_errorArgs);
    }

    @Override
    public String toString()
    {
        return getClass().getName() + ": " + getMessage();
    }
}