/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.mx.config;

import java.util.Set;

/**
 * <p>Title: IAttributeDescription</p>
 * <p>Description: The interface definition of an attribute description. An
 * attribute description defines the rules governing a specific attribute...
 * what kind of value is allowed, e.g. type, bounds, etc.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public interface IAttributeDescription extends Cloneable
{
    /**
     * A Boolean property indicating whether this attribute is an unenumerated
     * attribute map. Unenumerated attribute maps contain attributes with
     * varying names.
     */
    public static final String UNENUM_MAP_PROPERTY = "mx.config.unenumMap";

    /**
     * A Boolean property specifying whether this attribute can have an empty
     * value.
     */
    public static final String NILLABLE_PROPERTY = "mx.config.nillable";

    /**
     * A property specifying the fixed (constant) value of this attribute. This
     * property will be of the same type as the attribute.
     */
    public static final String FIXED_PROPERTY = "mx.config.fixed";

    /**
     * A property specifying the default value of this attribute. If the attribute's
     * value is not set in a config bean, this is the value the bean will return.
     * This property will be of the same type as the attribute.
     */
    public static final String DEFAULT_PROPERTY = "mx.config.default";

    /**
     * A Long property specifying the minimum number of times this attribute
     * can occur in an attribute map or list. The value of this property may
     * be any non-negative integer or the special value LENGTH_UNBOUNDED.
     * A value of '0' specifies that the attribute is optional and a value of
     * '1' specifies that the attribute is required. Note that values greater
     * than '1' are only valid when this attribute occurs in an attribute list.
     */
    public static final String MIN_OCCURS_PROPERTY = "mx.config.minOccurs";

    /**
     * A Long property specifying the maximum number of times this attribute
     * can occur in an attribute map or list. Note that values greater than '1'
     * are only valid when this attribute occurs in an attribute list.
     */
    public static final String MAX_OCCURS_PROPERTY = "mx.config.maxOccurs";

    /**
     * For a MIN_OCCURS_PROPERTY & MAX_OCCURS_PROPERTY, this value specifies
     * that the occurrance is unbounded.
     */
    public static final Long LENGTH_UNBOUNDED = new Long(-1);

    /**
     * A String property containing the name of the schema type declaration
     * that describes the attribute's type.
     */
    public static final String SCHEMA_TYPE_NAME = "mx.config.schemaTypeName";

    /**
     * A String property containing the name of the parent schema type declaration
     * that describes the enclosing type.
     */
    public static final String SCHEMA_SUPER_TYPE_NAME = "mx.config.schemaSuperTypeName";

    /**
     * A String property containing the name of the namespace in which this
     * description's schema attribute type was declared.
     */
    public static final String SCHEMA_NAMESPACE = "mx.config.schemaNamespace";

    /**
     * A String property containing the javadoc attribute description.
     */
    public static final String SCHEMA_ANNOTATION = "mx.config.schemaAnnotation";

    /**
     * A String property containing the tooltip attribute description.
     */
    public static final String TO0LTIP_ANNOTATION = "mx.config.tooltipAnnotation";

    /**
     * Type Name - for INTERNAL use only.
     */
    public static final String SIMPLE_TYPE_NAME = "mx.config.simpleTypeName";

    //-------------------------------------------------------------------------
    //
    //  Attribute Description Facets
    //
    // Facets are attribute description properties that restrict the values
    // that this attribute may assume. Facets only apply to String, Boolean,
    // Long, BigDecimal, Date, byte[] and IConfigElement attributes
    //
    //-------------------------------------------------------------------------

    /**
     * A Long property specifying the whitespace normalization rules on the
     * value of this attribute. The value of this property may be:
     *
     *   WHITESPACE_PRESERVE, WHITESPACE_REPLACE, WHITESPACE_COLLAPSE
     */
    public static final String WHITESPACE_FACET = "mx.config.whiteSpace";

    /**
     * A WHITESPACE_FACET value - all whitespace is preserved.
     */
    public static final Long WHITESPACE_PRESERVE = new Long(0);

    /**
     * A WHITESPACE_FACET value - each tab, line feed and carriage return is
     * replaced with a single space.
     */
    public static final Long WHITESPACE_REPLACE = new Long(1);

    /**
     * A WHITESPACE_FACET value - each tab, line feed and carriage return is
     * replaced with a single space.
     * Then all consecutive spaces are replaced with a single space. Leading
     * and trailing whitespace is deleted.
     */
    public static final Long WHITESPACE_COLLAPSE = new Long(2);

    /**
     * A Long property specifying the length of a String, IConfigElement, byte[]
     * or IAttributeList attribute. The value of this property may be any
     * non-negative integer.
     */
    public static final String LENGTH_FACET = "mx.config.length";

    /**
     * A Long property specifying the minimum length of a String, IConfigElement,
     * byte[] or IAttributeList attribute. The value of this property may be any
     * non-negative integer.
     */
    public static final String MIN_LENGTH_FACET = "mx.config.minLength";

    /**
     * A Long property specifying the maximum length of a String, IConfigElement,
     * byte[] or IAttributeList attribute. The value of this property may be any
     * non-negative integer or the special value LENGTH_UNBOUNDED.
     */
    public static final String MAX_LENGTH_FACET = "mx.config.maxLength";

    /**
     * An Long property specifying the maximum number of digits in a numeric
     * attribute. The value of this property may be any non-negatice integer.
     */
    public static final String TOTAL_DIGITS_FACET = "mx.config.totalDigits";

    /**
     * A Long property specifying the maximum number of fractional digits
     * in a numeric attribute. The value of this property may be any non-negatice
     * integer.
     */
    public static final String FRACTION_DIGITS_FACET = "mx.config.fractionDigits";

    /**
     * An attribute list property, the facet is an attribute map containing a
     * PATTERN_REGEX and a PATTERN_OPTION string property.
     */
    public static final String PATTERN_FACETS = "mx.config.pattern";

    /**
     * In a attribute list property, a PATTERN_FACET defines the regex for the
     * pattern.
     *
     * The PATTERN_REGEX attribute is the regular expression of the pattern.
     */
    public static final String PATTERN_REGEX  = "mx.config.regex.pattern";

    /**
     * In a attribute list, a PATTERN_OPTION definition describes the various
     * options controlling the pattern regex.
     *
     * The PATTERN_OPTION attribute is a string containing any one of the
     * following letters:
     *
     *     'i', 'm', 's', 'u', 'w', ',', 'X'
     */
    public static final String PATTERN_OPTION = "mx.config.regex.options";

    /**
     * An attribute list property containing a list of valid values for an
     * attribute. Items in the list will be of the same type as the attribute.
     */
    public static final String EMUMERATION_FACET = "mx.config.enumeration";

    /**
     * An Date or numeric property containing the maximum value that a Date or
     * numeric attribute can assume. The property will be of the same type as
     * the attribute.
     */
    public static final String MAX_INCLUSIVE_FACET = "mx.config.maxInclusive";

    /**
     * An Date or numeric property containing a value that the value of a Date
     * or numeric attribute must be less than. The property will be of the same
     * type as the attribute.
     */
    public static final String MAX_EXCLUSIVE_FACET = "mx.config.maxExclusive";

    /**
     * A Date or numeric property containing a value that the value of a Date
     * or numeric attribute must be greater than. The property will be of the same
     * type as the attribute.
     */
    public static final String MIN_EXCLUSIVE_FACET = "mx.config.minExclusive";

    /**
     * A Date or numeric property containing the minumum value that a Date or
     * numeric attribute can assume. The property will be of the same type as
     * the attribute.
     */
    public static final String MIN_INCLUSIVE_FACET = "mx.config.minInclusive";

    //-------------------------------------------------------------------------

    /**
     * Creates a copy (clone) of this attribute description.
     *
     * @return  An identical copy of this attribute description.
     */
    public Object clone();

    /**
     * Text Description of Attribute
     *
     * @return  A String value providing the attribute with a text description.
     */
    public String getDescription();

    /**
     * The Java Class Type of the Attribute.
     *
     * @return  The Java class type.
     */
    public Class getType();

    /**
     * Gets a property of the attribute.
     *
     * @param propertyName  The name or key of the attribute description property.
     * @return              The property value or <code>null</code> if no value /
     *                      property exists.
     */
    public Object getProperty(String propertyName);

    /**
     * Gets all the property names (keys) available on the attribute description.
     *
     * @return  A set of String's defining the list of all available properties
     *          for this attribute description.
     */
    public Set getPropertyNames();

    /**
     * Gets the child attribute description.
     *
     * @param attributeName  The name (key) of the child attribute description.
     * @return               The attribute description or <code>null</code> if
     *                       no attribute description with that name exists.
     */
    public IAttributeDescription getAttributeDescription(String attributeName);

    /**
     * Gets the child attribute description using a path. If the path has
     * multiple parts then the method will traverse the attribute description
     * tree while the path parts continue to map onto actual child attribute
     * descriptions.
     *
     * @param path  The path to a (sub) child attribute description.
     * @return      The attribute description or <code>null</code> if
     *              no attribute description with that name exists.
     */
    public IAttributeDescription getAttributeDescription(IConfigPath path);

    /**
     * Gets a set of the names (keys) to all immediate child attribute
     * descriptions.
     *
     * @return  A set containing all immediate child attribute description names.
     */
    public Set getAttributeDescriptionNames();

    /**
     * Validates the value (content) according to this attribute description.
     * Basically, the String value is converted into the required type (if
     * necessary) and checks performed based on type, bounding, etc.
     *
     * @param value                    The content or String value to be validated.
     * @return                         The validated content in its native (Java)
     *                                 object format.
     * @throws ConfigServiceException  An exception if the validation fails.
     */
    public Object validate(String value)
        throws ConfigServiceException;

    /**
     * Validates the value (content) according to the property and facet rules
     * found in this attribute description.
     *
     * @param value                    The content or String value to be validated.
     * @throws ConfigServiceException  An exception if the validation fails.
     */
    public void validate(Object value)
        throws ConfigServiceException;
}
