/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mx.config;

import java.util.List;

/**
 * <p>Title: IAttributeList</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public interface IAttributeList extends List, Cloneable
{
    /**
     * Creates a copy (clone) of this attribute list.
     *
     * @return  An identical copy of this attribute list.
     */
    public Object clone();

    /**
     *
     * @param attribute
     * @throws ConfigAttributeException
     */
    public void addAttribute(Object attribute)
        throws ConfigAttributeException;

    /**
     *
     * @param index
     * @param attribute
     * @throws ConfigAttributeException
     */
    public void addAttribute(int index, Object attribute)
        throws ConfigAttributeException;

    /**
     *
     * @param index
     * @param attribute
     * @throws ConfigAttributeException
     */
    public void setAttribute(int index, Object attribute)
        throws ConfigAttributeException;

    /**
     *
     * @param index
     * @return
     */
    public Object getAttribute(int index);

    /**
     *
     * @param index
     * @return
     */
    public IAttributeMetaData getAttributeMetaData(int index);

    /**
     *
     * @param index
     * @return
     * @throws ConfigAttributeException
     */
    public Object removeAttribute(int index)
        throws ConfigAttributeException;

    /**
     *
     * @param attribute
     * @return
     * @throws ConfigAttributeException
     */
    public boolean removeAttribute(Object attribute)
        throws ConfigAttributeException;

    /**
     *
     * @param path
     * @param attribute
     * @throws ConfigAttributeException
     */
    public void setAttribute(IConfigPath path, Object attribute)
        throws ConfigAttributeException;

    /**
     *
     * @param path
     * @return
     */
    public Object getAttribute(IConfigPath path);

    /**
     *
     * @param path
     * @return
     */
    public IAttributeMetaData getAttributeMetaData(IConfigPath path);

    /**
     *
     * @param path
     * @return
     * @throws ConfigAttributeException
     */
    public Object removeAttribute(IConfigPath path)
        throws ConfigAttributeException;

    /**
     *
     * @param attributes
     * @throws ConfigAttributeException
     */
    public void addAttributes(IAttributeList attributes)
        throws ConfigAttributeException;

    /**
     *
     * @param index
     * @param attributes
     * @throws ConfigAttributeException
     */
    public void addAttributes(int index, IAttributeList attributes)
        throws ConfigAttributeException;

    /**
     *
     * @param attributes
     * @return
     * @throws ConfigAttributeException
     */
    public boolean removeAttributes(IAttributeList attributes)
        throws ConfigAttributeException;

    /**
     *
     * @return
     */
    public IAttributeDescription getAttributeDescription();

    /**
     *
     * @param name
     * @return
     * @throws ConfigAttributeException
     */
    public IAttributeMap createAttributeMap(String name)
        throws ConfigAttributeException;

    /**
     *
     * @param name
     * @return
     * @throws ConfigAttributeException
     */
    public IAttributeList createAttributeList(String name)
        throws ConfigAttributeException;

    /**
     *
     * @throws ConfigAttributeException
     */
    public void validateComplete()
        throws ConfigAttributeException;

    /**
     *
     * @return
     */
    public String toXML();
}
