/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.mx.config;

import java.util.Map;
import java.util.Set;

/**
 * <p>Title: IAttributeMap</p>
 * <p>Description: The main data structure used in the Config Layer to create
 * structure in elements. An attribute map is a key/value based structure and
 * extends the Collections Map interface.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public interface IAttributeMap extends Map, Cloneable
{
    /**
     *
     * @return
     */
    public Object clone();

    /**
     *
     * @param attributeName
     * @return
     */
    public Object getAttribute(String attributeName);

    /**
     *
     * @param attributeName
     * @return
     * @throws ConfigAttributeException
     */
    public IAttributeMetaData getAttributeMetaData(String attributeName)
        throws ConfigAttributeException;

    /**
     *
     * @param attributeName
     * @param attributeValue
     * @throws ConfigAttributeException
     */
    public void setAttribute(String attributeName, Object attributeValue)
        throws ConfigAttributeException;

    /**
     *
     * @param attributeName
     * @return
     * @throws ConfigAttributeException
     */
    public Object removeAttribute(String attributeName)
        throws ConfigAttributeException;

    /**
     *
     * @param path
     * @return
     */
    public Object getAttribute(IConfigPath path);

    /**
     *
     * @param path
     * @return
     * @throws ConfigAttributeException
     */
    public IAttributeMetaData getAttributeMetaData(IConfigPath path)
        throws ConfigAttributeException;

    /**
     *
     * @param path
     * @param attributeValue
     * @throws ConfigAttributeException
     */
    public void setAttribute(IConfigPath path, Object attributeValue)
        throws ConfigAttributeException;

    /**
     *
     * @param path
     * @return
     * @throws ConfigAttributeException
     */
    public Object removeAttribute(IConfigPath path)
        throws ConfigAttributeException;

    /**
     *
     * @param attributeNames
     * @return
     */
    public IAttributeMap getAttributes(Set attributeNames);

    /**
     *
     * @param attributes
     * @throws ConfigAttributeException
     */
    public void setAttributes(IAttributeMap attributes)
        throws ConfigAttributeException;

    /**
     *
     * @param attributeNames
     * @return
     * @throws ConfigAttributeException
     */
    public IAttributeMap removeAttributes(Set attributeNames)
        throws ConfigAttributeException;

    /**
     *
     * @return
     */
    public Set getAttributeNames();

    /**
     *
     * @return
     */
    public IAttributeDescription getAttributeDescription();

    /**
     *
     * @param name
     * @return
     * @throws ConfigAttributeException
     */
    public IAttributeMap createAttributeMap(String name)
        throws ConfigAttributeException;

    /**
     *
     * @param name
     * @return
     * @throws ConfigAttributeException
     */
    public IAttributeList createAttributeList(String name)
        throws ConfigAttributeException;

    /**
     *
     * @param attributeName
     * @param listener
     * @param handback
     * @throws ConfigServiceException
     */
    public void addConfigChangeListener(IConfigPath           attributeName,
                                        IConfigChangeListener listener,
                                        Object                handback)
        throws ConfigServiceException;

    /**
     *
     * @param attributeName
     * @param listener
     * @param handback
     * @throws ConfigServiceException
     */
    public void removeConfigChangeListener(IConfigPath           attributeName,
                                           IConfigChangeListener listener,
                                           Object                handback)
        throws ConfigServiceException;

    /**
     *
     * @throws ConfigAttributeException
     */
    public void validateComplete()
        throws ConfigAttributeException;

    /**
     *
     * @return
     */
    public String toXML();
}
