/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.mx.config;

/**
 * <p>Title: IAttributeMetaData</p>
 * <p>Description: Provides a way of exposing attribute source information.
 * An attribute (value) may come from the local element, a linked prototype
 * (template) if the element is an instance, or from the config type if the
 * attribute has a default value, for example.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public interface IAttributeMetaData
{
    /**
     * If the attribute is referenced from a config instance element then that
     * attribute might not actually be stored in the instance. It may be
     * 'inherited' from the template (or prototype) element.
     *
     * @return  <code>true</code> if the attribute comes from a prototype;
     *          <code>false</code> otherwise.
     */
    public boolean isFromPrototype();

    /**
     * The attribute (value) may come from the underlying config type.
     * e.g. a default value.
     *
     * @return  <code>true</code> if the attribute comes from the config type;
     *          <code>false</code> otherwise.
     */
    public boolean isFromConfigType();

    /**
     * If the attribute comes from the config bean (element), i.e. the attribute
     * is stored locally/directly in the element.
     *
     * @return  <code>true</code> if the attribute comes from the bean;
     *          <code>false</code> otherwise.
     */
    public boolean isFromConfigBean();
}
