package com.sonicsw.mx.config;

import java.io.InputStream;

/**
 * <p>Title: IConfigBeanFile</p>
 * <p>Description: The interface definition that defines a file extension to
 * a config bean. This file element representation is a config bean with a
 * fixed type - MF_FILE, that allows blob attachments and some custom info
 * associated with FS items.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public interface IConfigBeanFile extends IConfigBean
{
    /**
     * Gets the date/time when this file element was created.
     *
     * @return  The <code>long</code> value representing the creation date/time.
     */
    @Override
    public long getCreationTime();

    /**
     * Gets the date/time when this file element was last modified.
     *
     * @return  The <code>long</code> value that represents when this file was
     *          last modified.
     */
    public long getLastModifiedTime();

    /**
     * The user/administrator that created the file.
     *
     * @return  A string representing the user that created/first added this file.
     */
    public String getCreateBy();

    /**
     * The size in bytes of the attached file.
     *
     * @return  The size (in bytes) of the file.
     */
    public int getFileSize();

    /**
     * This method is used to set the blob in the file element. The new blob
     * provided by the <code>InputStream</code> replaces any previous blob that
     * was attached to the file element.
     *
     * @param contents                 The blob (contents) in an input stream.
     * @throws ConfigServiceException  An exception if the blob fails to attach
     *                                 to the file element.
     */
    public void setContents(InputStream contents)
        throws ConfigServiceException;

    /**
     * This methods returns the attached blob content (if any) as an InputStream.
     *
     * @return                         The blob content in <code>InputStream</code>
     *                                 form; or <code>null</code> if no content
     *                                 exists.
     * @throws ConfigServiceException  An exception if the method fails to
     *                                 retrieve the content.
     */
    public InputStream getContents()
        throws ConfigServiceException;
}
