package com.sonicsw.mx.config;

/**
 * <p>Title: IConfigChangeFilter</p>
 * <p>Description: The interface definition of a filter that allows implementors
 * to selectively filter out change notifications.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public interface IConfigChangeFilter
{
    /**
     * This method takes a config change notification and must work out from
     * this whether or not to process the change. Implementors can determine
     * using this method if the change notification should be discarded.
     *
     * @param configChange  The ConfigChange event/notification that may or
     *                      may not be discarded.
     * @return              <code>true</code> if the change notification should
     *                      be processed; otherwise <code>false</code> if the
     *                      change is to be discarded / ignored.
     */
    public boolean isConfigChangeEnabled(ConfigChange configChange);
}