package com.sonicsw.mx.config;

import java.util.EventListener;

/**
 * <p>Title: IConfigChangeListener</p>
 * <p>Description: Interface definition for a <code>ConfigChange</code>-specific
 * event listener that allows implementors to receive notification of the various
 * config changes as they occur.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public interface IConfigChangeListener extends EventListener
{
    /**
     * Called if the change notification is the result of an element being
     * added into the Directory Service store.
     *
     * @param configChange  The config change event.
     */
    public void elementAdded(ConfigChange configChange);

    /**
     *
     * Called if an element has been updated.
     *
     * @param configChange  The config change event.
     */
    public void elementUpdated(ConfigChange configChange);

    /**
     *
     * Called if an element has been replaced by another element.
     *
     * @param configChange  The config change event.
     */
    public void elementReplaced(ConfigChange configChange);

    /**
     *
     * Called if an element has been removed from the Directory Service store.
     *
     * @param configChange  The config change event.
     */
    public void elementDeleted(ConfigChange configChange);

    /**
     * Method is called if a folder was added to the Directory Service structure.
     *
     * @param configChange  The config change event.
     */
    public void folderAdded(ConfigChange configChange);

    /**
     * Called if a folder was removed from the Directory Service structure.
     *
     * @param configChange  The config change event.
     */
    public void folderDeleted(ConfigChange configChange);

    /**
     * Called if a folder or element has been renamed.
     *
     * @param configChange  The config change event.
     */
    public void rename(ConfigChange configChange);

    /**
     * Called if the meta attributes for a folder or element have been modified.
     *
     * @param configChange  The config change event.
     */
    public void metaAttributesChanged(ConfigChange configChange);
}
