/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mx.config;

import java.util.Set;

/**
 * <p>Title: IConfigPrototype</p>
 * <p>Description: The interface definition of a config prototype - basically
 * a special kind of config element that can have linked subclasses or
 * instances.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public interface IConfigPrototype extends IConfigElement
{
    /**
     * Mechanism by which new instance config elements are created that are
     * linked (refer) to this prototype config element.
     *
     * @param name                     The new name (fully qualified path) where
     *                                 the new instance config element is to be
     *                                 located in the DS.
     * @return                         The newly created instance config element
     * @throws ConfigServiceException  If the Config Layer fails to create the
     *                                 linked instance config element then this
     *                                 exception is thrown.
     */
    public IConfigElement newInstance(String name)
        throws ConfigServiceException;

    /**
     * Fetches all the instance config elements that are linked (associated)
     * with this prototype (template) config element.
     *
     * @return                         A <code>Set</code> that contains all the
     *                                 instance config elements <code>IConfigElement</code>
     *                                 that are tied to this prototype config
     *                                 element.  If the prototype has no instances
     *                                 then an empty set is returned.
     * @throws ConfigServiceException  If a failure occurs then an exception
     *                                 is thrown...if the failure is in the DS
     *                                 then that specific exception is wrapped.
     */
    public Set getPrototypeInstances()
        throws ConfigServiceException;
}
