/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mx.config;

/**
 * <p>Title: IConfigType</p>
 * <p>Description: The interface definition for a config type - implementors
 * of this interface provide a why of maintaining validation information about
 * the structure and content of an associated config element.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public interface IConfigType extends IAttributeDescription
{
    /**
     * Schema Document Location
     *
     * A String property specifying the document location of the schema in
     * which the config type was declared.
     */
    public static final String SCHEMA_LOCATION_HINT = "mx.config.schemaLocationHint";


    /**
     * Indicates whether some other object is "equal to" this one.
     *
     * @param obj  the reference object with which to compare.
     * @return     <code>true</code> if this object is the same as the obj
     *             argument; <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object obj);

    /**
     * Gets this config type's name.
     *
     * @return  This config type's name.
     */
    public String getName();

    /**
     * If this type derives itself from another type then this method will
     * return that super or parent type.
     *
     * @return  The super config type from which this config type is derived.
     */
    public IConfigType getSuper();

    /**
     * Gets the config version of this config type.
     *
     * @return  The config version as a string. Generally this will be in the
     *          format "x.x" or "x.x.x" where the x's stand for major, minor
     *          and patch release numbers.
     */
    public String getVersion();

    /**
     * The text description of the config type.
     *
     * @return  The <code>String</code> description of the config type.
     */
    @Override
    public String getDescription();

    /**
     * Gets the ConfigServer with which this config type was loaded.
     *
     * @return  The <code>ConfigServer</code> that loaded this config type.
     */
    public IConfigServer getConfigServer();
}
