/*
 * Copyright (c) 2004 Sonic Software Inc
 *
 * This software is the confidential and proprietary information of Sonic
 * Software. You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the source code
 * license agreement you entered into with Sonic Software.
 *
 */
package com.sonicsw.mx.config;


/**
 * @author <a href="mailto:murali@sonicsoftware.com">Murali Mohan</a>
 * @since: Feb 2, 2007
 */
public abstract class IdentityOnlyConfigBean implements IConfigBean {

    private static boolean enabled = false;

    public static volatile IConfigBean unIndentifiable = null;

    /**
     * Should be used by only those clients who could deal wo  // todo
     * @param flag
     */
    public static void setEnabled(boolean flag){
        enabled = flag;
        if(!enabled){
            unIndentifiable = null;
        }
    }

    public static boolean isEnabled(){
        return enabled;
    }

    /**
     * The single marker bean for all  Config References whose identity
     * could not be resolved due to FGS restrictions. Is null if
     * the IdentityOnlyConfigBean support is disabled or
     * if no such refernce has been encountered yet.
     * @return
     */
    public static IConfigBean getUnIndentifiable() {
        return unIndentifiable;
    }

    /**
     * Returns true if the argument is an  IdentityOnlyConfigBean whose name and type
     * cant be resolved
     * @param bean
     * @return
     */
    public static boolean isUnidentifiable(IConfigBean bean){
        if(bean instanceof IdentityOnlyConfigBean){
            return ((IdentityOnlyConfigBean) bean).isUnidentifiable();
        }
        return false;
    }


    /**
     * @param bean
     * @return !isUnidentifiable(IConfigBean bean)
     */
    public static boolean isIdentifiable(IConfigBean bean){
        return !isUnidentifiable(bean);
    }

    public abstract boolean isUnidentifiable();

    /**
     * Put here to pass compilation
     * @return
     * @see IAttributeMap#clone()
     */
    @Override
    public abstract Object clone();

}
