package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.IAttributeMetaData;

public class AttributeMetaData
implements IAttributeMetaData
{
    public static final int IS_FROM_PROTOTYPE = 0;
    public static final int IS_FROM_CONFIG_TYPE = 1;
    public static final int IS_FROM_CONFIG_BEAN = 2;

    public static final AttributeMetaData s_isFromPrototype = new AttributeMetaData(IS_FROM_PROTOTYPE);

    public static final AttributeMetaData s_isFromConfigType = new AttributeMetaData(IS_FROM_CONFIG_TYPE);

    public static final AttributeMetaData s_isFromConfigBean = new AttributeMetaData(IS_FROM_CONFIG_BEAN);

    protected int m_attributeOrigin;

    protected String m_attributeName;

    protected Object m_attributeValue;

    protected AttributeMetaData(int attributeOrigin)
    throws IllegalArgumentException
    {
        m_attributeOrigin = attributeOrigin;
    }

    protected AttributeMetaData(com.sonicsw.mf.common.config.IAttributeMetaData metaData)
    {
        m_attributeOrigin = metaData.isFromTemplate() ? IS_FROM_PROTOTYPE : IS_FROM_CONFIG_BEAN;
    }

    @Override
    public boolean
    isFromPrototype()
    {
        return m_attributeOrigin == IS_FROM_PROTOTYPE;
    }

    @Override
    public boolean
    isFromConfigType()
    {
        return m_attributeOrigin == IS_FROM_CONFIG_TYPE;
    }

    @Override
    public boolean
    isFromConfigBean()
    {
        return m_attributeOrigin == IS_FROM_CONFIG_BEAN;
    }

    @Override
    public String
    toString()
    {
        switch (m_attributeOrigin)
        {
        case IS_FROM_CONFIG_BEAN:
            return "is from config bean";
        case IS_FROM_CONFIG_TYPE:
            return "is from config type";
        case IS_FROM_PROTOTYPE:
            return "is from config prototype";
        default:
            return "is from unknown";
        }
    }
}