package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigElement;

public class CacheDispatcherModule
extends DispatcherModule
{
    public CacheDispatcherModule(ConfigServer cs)
    {
        super(cs);
    }


    @Override
    public boolean processConfigChange(ConfigChange configChange)
    {
        switch (configChange.getChangeType())
        {
        case ConfigChange.ELEMENT_UPDATED:
            try
            {
                /*  An element has been modified in the DS:
                    First check to see if we have this item locally. */
                IConfigElement local = m_cs.loadLocalConfigElement(configChange.getName());

                if(local != null)
                {
                    //  The element had been loaded locally.
                    //  See if it has been modified by local edits.
                    if(!local.isModified())
                    {
                        // Element has not been edited locally: update it with new state
                        local.refresh();
                    }
                    else
                    {
                        m_cs.debugPrintln("CacheDispatcherModule - ignore update for " + configChange.getName() + " since config is modified");
                    }
                }
            }
            catch (ConfigServiceException e)
            {
                /* ignore */
            }
            break;

        case ConfigChange.ELEMENT_DELETED:
            try
            {
                /*  An element has been modified in the DS:
                    First check to see if we have this item locally. */
                IConfigElement local = m_cs.loadLocalConfigElement(configChange.getName());

                if(local != null)
                {
                    /*  The element had been loaded locally:
                        place it in the 'removed' state. */
                    ((ConfigElementImpl)local).setRemoved();
                }
            }
            catch (ConfigServiceException e)
            {
                /* ignore */
            }
            break;

        case ConfigChange.RENAME:
            try
            {
                Object[] list = m_cs.getElementCache().lookup(configChange.getName());

                m_cs.debugPrintln("rename " + configChange.getName() + " > " + configChange.getNewName() + " : " + list.length);

                for (int i = 0; i < list.length; i++)
                {
                    if ((list[i] == null) || !(list[i] instanceof ConfigElementImpl))
                    {
                        continue;
                    }

                    ConfigElementImpl local = (ConfigElementImpl)list[i];

                    // check for locally created element
                    //
                    if (local.isNew())
                    {
                        continue;
                    }

                    int index = local.getName().indexOf(configChange.getName());
                    String newName = configChange.getNewName() + local.getName().substring(index + configChange.getName().length());

                    m_cs.debugPrintln("rename["+i+"] : " + local.getName() + " to " + newName);

                    // Make sure cache entry with old name is removed...
                    //
                    m_cs.getElementCache().remove(local.getName(), "");

                    // Rename local entry so that it uses new name
                    //
                    local.setDirectoryElementName(newName);
                    local.m_name = newName;

                    // This cache key may need updating if it doesn't exist...
                    //
                    if (m_cs.getElementCache().lookup(newName, "") == null)
                    {
                        m_cs.getElementCache().add(newName, "", local);
                    }
                }
            }
            catch (ConfigServiceException e)
            {
                /* ignore */
            }
            break;
        default:
            /* NOOP */
        }

        return true;
    }

}