package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.IAnnotationExtension;
import com.sonicsw.mx.config.IConfigPath;

public class CheckForEmptyDispatcherModule extends DispatcherModule
{
    // This Dispatcher Module checks for empty delta change notifications
    // from the DS and discards them before they are processed by the rest of
    // the system.
    // Empty notifications are typically because the DS is sending notifications
    // when the _MF_SYSTEM_ATTRIBUTES are updated on a template or instance.

    public CheckForEmptyDispatcherModule(ConfigServer cs)
    {
        super(cs);
    }

    @Override
    public boolean processConfigChange(ConfigChange configChange)
    {
        if(configChange.getChangeType() == ConfigChange.ELEMENT_UPDATED)
        {
            if(isEmptyConfigChange(configChange))
            {
                m_cs.debugPrintln("CheckForEmptyDispatcher - discard update for " + configChange.getName());

                return false;
            }
        }
        return true;
    }

    private boolean isEmptyConfigChange(ConfigChange configChange)
    {
        // if we have deleted attributes then !empty
        if(!configChange.getDeletedAttributeNames().isEmpty())
        {
            return false;
        }
         

        // if we have more than one new attributes then !empty
        if(configChange.getNewAttributeNames().size() > 1)
        {
            return false;
        }

        // if we have more than one modified attribute then !empty
        if(configChange.getModifiedAttributeNames().size() > 1)
        {
            return false;
        }

        // if we have exactly one new attribute and one modified attribute
        // then !empty
        if(configChange.getNewAttributeNames().size()      == 1 &&
           configChange.getModifiedAttributeNames().size() == 1)
        {
            return false;
        }

        // if we have exactly one new attribute
        // then this may just be an update to the MF_SYSTEM_ATTRIBUTES
        if(configChange.getNewAttributeNames().size() == 1)
        {
            Object obj = configChange.getNewAttributeNames().iterator().next();

            if(obj instanceof IConfigPath)
            {
                if (!((IConfigPath)obj).getFirstComponent().equals("_MF_SYSTEM_ATTRIBUTES"))
                {
                    return false;
                }

                // otherwise it is == _MF_SYSTEM_ATTRIBUTES and TOOL_EXTENTION is changed 
                if (((IConfigPath)obj).size() > 1 && ((IConfigPath)obj).getComponent(1).equals(IAnnotationExtension.TOOL_ANNOTATION))
                {
                    return false;
                }
                
                // otherwise it is == _MF_SYSTEM_ATTRIBUTES so we need to
                // check whether there is a single new attribute and it is
                // for a RELEASE_VERSION change
                if(configChange.isReleaseVersion())
                {
                    return false;
                }
            }
        }

        // if we have exactly one modified attribute
        // then this may just be an update to the MF_SYSTEM_ATTRIBUTES
        if(configChange.getModifiedAttributeNames().size() == 1)
        {
            Object obj = configChange.getModifiedAttributeNames().iterator().next();

            if(obj instanceof IConfigPath)
            {
                if(!((IConfigPath)obj).getFirstComponent().equals("_MF_SYSTEM_ATTRIBUTES"))
                {
                    return false;
                }

                //otherwise it is == _MF_SYSTEM_ATTRIBUTES and TOOL_EXTENTION is changed 
                if (((IConfigPath)obj).getComponent(1).equals(IAnnotationExtension.TOOL_ANNOTATION))
                {
                    return false;
                }
                
                // otherwise it is == _MF_SYSTEM_ATTRIRBUTES so we need to
                // check whether there is a single new attribute and it is
                // for a RELEASE_VERSION change
                if(configChange.isReleaseVersion())
                {
                    return false;
                }
            }
        }
        return true;
    }
}