package com.sonicsw.mx.config.impl;

import java.io.StringReader;
import java.util.EmptyStackException;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAnnotationExtension;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;

public class ConfigBeanDocument
{
    public static final boolean DEBUG = false;

    public static class VersionHandler extends DefaultHandler
    {
        // Started Processing Root Element Indicator.
        //  Indicates whether processing of the root
        //  element has started. This is used to indicate
        //  in the 'startElement' method that the root element
        //  is being processed; in which case the version is extracted from the config type element.
        private boolean m_startedRootElement = false;

        // Used to determine document locations of errors.
        Locator m_locator = null;

        String m_version = null;


        public VersionHandler()
        {
        }

        @Override
        public void setDocumentLocator (Locator locator)
        {
            m_locator = locator;
        }

        @Override
        public void
        startElement(String uri, String localName, String qname, Attributes attributes)
        throws SAXException
        {
            if (!m_startedRootElement)
            {
                // This is the root element: process schemaLocation attribute
                m_startedRootElement = true;

                // Retain type name of bean.
                //m_typeName = localName;

                // Retrieve the name and version of config bean from bean document element.
                int length = attributes.getLength();

                for (int i = 0; i < length; i++)
                {
                    if (attributes.getLocalName(i).equals("version"))
                    {
                        m_version = attributes.getValue(i);
                    }
                }

                if  (m_version == null)
                {
                    // Cannot store unversioned config bean
                    throw new SAXException("Error in configuration document '" + m_locator.getSystemId() + "' " +
                                           "at line number '" + m_locator.getLineNumber() + "' " +
                                           "column number '" + m_locator.getColumnNumber() + "' " +
                                           ": config bean element '" + localName + "' has no 'version' attribute defined.");
                }

            }
        }
    }

    public static class IdentityHandler extends DefaultHandler
    {
        // Started Processing Root Element Indicator.
        //  Indicates whether processing of the root
        //  element has started. This is used to indicate
        //  in the 'startElement' method that the root element
        //  is being processed; in which case the bean name
        //  type and version is extracted from the element.
        private boolean m_startedRootElement = false;

        // Used to determine document locations of errors.
        Locator m_locator = null;

        String m_name = null;

        String m_typeName = null;

        String m_version = null;

        String m_productVersion = null;

        public IdentityHandler()
        {
        }

        @Override
        public void setDocumentLocator (Locator locator)
        {
            m_locator = locator;
        }

        @Override
        public void
        startElement(String uri, String localName, String qname, Attributes attributes)
        throws SAXException
        {
            if (!m_startedRootElement)
            {
                // This is the root element: process schemaLocation attribute
                m_startedRootElement = true;

                // Retain type name of bean.
                m_typeName = localName;

                // Retrieve the name and version of config bean from bean document element.
                int length = attributes.getLength();

                for (int i = 0; i < length; i++)
                {
                    if (attributes.getLocalName(i).equals("name"))
                    {
                        m_name = Util.url2Name(attributes.getValue(i));
                    }
                    else if (attributes.getLocalName(i).equals("version"))
                    {
                        m_version = attributes.getValue(i);
                    }
                    else if (attributes.getLocalName(i).equals("productVersion"))
                    {
                        m_productVersion = attributes.getValue(i);
                    }
                }

                //  Validate that config bean has name and version
                if (m_name == null)
                {
                    // Cannot store unamed config bean
                    throw new SAXException("Error in configuration document '" + m_locator.getSystemId() + "' " +
                                           "at line number '" + m_locator.getLineNumber() + "' " +
                                           "column number '" + m_locator.getColumnNumber() + "' " +
                                           ": config bean element '" + localName + "' has no 'name' attribute defined.");
                }
                else
                if  (m_version == null)
                {
                    // Cannot store unversioned config bean
                    throw new SAXException("Error in configuration document '" + m_locator.getSystemId() + "' " +
                                           "at line number '" + m_locator.getLineNumber() + "' " +
                                           "column number '" + m_locator.getColumnNumber() + "' " +
                                           ": config bean element '" + localName + "' has no 'version' attribute defined.");
                }

            }
        }
    }

    public static class Handler extends DefaultHandler implements LexicalHandler
    {
        /*  Parsed Config Bean. */
        ConfigBeanImpl m_bean = null;

        /* Started Processing Root Element Indicator.

            Indicates whether processing of the root
            element has started. This is used to indicate
            in the 'startElement' method that the root element
            is being processed; in which case the schemaLocation
            is extracted from the element and the ConfigType
            is generated.
        */
        private boolean m_startedRootElement = false;

        /*  Parent Config Object Stack

            Top of stack contains the parent config object
            of the current config object being parsed. A config
            object will add itself to this parent when it
            has been parsed.
        */
        java.util.Stack m_parentConfigObjects = new java.util.Stack();

        /*  Config Object Description Stack

            Top of stack contains the type description of the
            the current config object being parsed. When parsing of
            the XML document element for a config object begins, the
            type description of that object is retreived from its
            parent's description which is at the top of the stack.
            The description object is used to validate and convert
            the character content of its xml document element into
            a runtime value.

            An entry in the stack will be an IAttributeDescription
            for either an IAttributeMap or an IAttributeList.
        */
        java.util.Stack m_configObjectDescs = new java.util.Stack();

        /*  Character Content Buffer

            The character content of the config object
            currently being parsed is accumulated in
            the string buffer.
        */
        StringBuffer m_characterContent = null;

        /*  Config Server Connection

            Used to lookup config type for bean.
        */
        IConfigServer m_configServer = null;

        /*  Config Type

            Used to validate parsed Config Bean
        */
        IConfigType m_configType = null;

        /** Document Locator
         *
         * Used to determine document locations of errors.
         */
        Locator m_locator = null;

        /** Replace Config Bean
         *
         *  Indicates whether or not to replace existing config bean in config server.
         */
        boolean m_replaceConfigBean = false;

        private static final String UNENUM_NAME = "com.sonicsw.mx.config.impl.ConfigBeanDocument.unenumName";

        /*
         * Detects TOOL_ANNOTATION element 
         */
        private boolean isAnnotation = false;
        /*
         * Indicates start of CDATA section, if set to true collects chars to 
         * the CDATA content string buffer, see  characters(char[] ch, int offset, int length)
         */
        private boolean m_isCData = false;
        
        /*
         * Buffer to collect CDATA content
         */
        private  StringBuffer m_contentCDATA = new StringBuffer();
        
        
        public Handler(IConfigServer configServer)
        {
            m_configServer = configServer;
        }

        public Handler(IConfigServer configServer, boolean replaceConfigBean)
        {
            m_configServer = configServer;
            m_replaceConfigBean = replaceConfigBean;
        }

        @Override
        public void setDocumentLocator (Locator locator)
        {
            m_locator = locator;
        }

        @Override
        public void
        startElement(String uri, String localName, String qname, Attributes attributes)
        throws SAXException
        {
            if (!m_startedRootElement)
            {
                // This is the root element: process schemaLocation attribute
                m_startedRootElement = true;

                // Retrieve the name and version of config bean from bean document element.
                String name = null;
                String version = null;
                String productVersion = null;
                int length = attributes.getLength();
                for (int i = 0; i < length; i++)
                {
                    if(attributes.getLocalName(i).equals("name"))
                    {
                        name = Util.url2Name(attributes.getValue(i));
                    }
                    else if(attributes.getLocalName(i).equals("version"))
                    {
                        version = attributes.getValue(i);
                    }
                    else if (attributes.getLocalName(i).equals("productVersion"))
                    {
                        productVersion = attributes.getValue(i);
                    }
                }

                /*  Validate that config bean has name and version */
                if (name == null)
                {   /* Cannot store unamed config bean */
                    throw new SAXException("Error in configuration document '" + m_locator.getSystemId() + "' " +
                                           "at line number '" + m_locator.getLineNumber() + "' " +
                                           "column number '" + m_locator.getColumnNumber() + "' " +
                                           ": config bean element '" + localName + "' has no 'name' attribute defined.");
                }
                else
                if  (version == null)
                {   /* Cannot store unversioned config bean */
                    throw new SAXException("Error in configuration document '" + m_locator.getSystemId() + "' " +
                                           "at line number '" + m_locator.getLineNumber() + "' " +
                                           "column number '" + m_locator.getColumnNumber() + "' " +
                                           ": config bean element '" + localName + "' has no 'version' attribute defined.");
                }

                if (m_configType != null)
                {   /*  Validate that config type matches bean type. */
                    if (!m_configType.getName().equals(localName))
                    {
                        throw new SAXException("Error in configuration document '" + m_locator.getSystemId() + "' " +
                                               "at line number '" + m_locator.getLineNumber() + "' " +
                                               "column number '" + m_locator.getColumnNumber() + "' " +
                                               ": configuration type '" + localName + "' does not match " + m_configType.getName() + ".");
                    }
                }
                else
                {   /*  Get config type for this bean. */
                    try
                    {
                        m_configType = m_configServer.loadConfigType(localName, version);
                        if (m_configType == null)
                        {
                            throw new SAXException("Error in configuration document '" + m_locator.getSystemId() + "' " +
                                                   "at line number '" + m_locator.getLineNumber() + "' " +
                                                   "column number '" + m_locator.getColumnNumber() + "' " +
                                                   ": configuration type '" + localName + "' does not exist in config server.");
                        }
                    }
                    catch (ConfigServiceException e)
                    {
                        throw new SAXException("Error in configuration document '" + m_locator.getSystemId() + "' " +
                                               "at line number '" + m_locator.getLineNumber() + "' " +
                                               "column number '" + m_locator.getColumnNumber() + "' " +
                                               ": configuration type '" + localName + "' does not exist in config server.");
                    }
                }

                // Push attribute description for the attributes of the config bean
                // onto description stack:
                // This attribute description will be used by the child elements of
                // the config bean to retieve their own attribute descriptions.
                m_configObjectDescs.push(m_configType);

                try
                {
                    if (m_replaceConfigBean)
                    {
                        try
                        {
                            m_bean = (ConfigBeanImpl) m_configServer.loadConfigElement(name);
                        }
                        catch(Exception e)
                        {
                            // Do nothing
                        }
                    }

                    if (m_bean != null)
                    {
                        m_bean.clear();

                        // Bean can't be an instance here!! (!m_bean.isInstance)
                        if (!m_bean.isPrototypeInstance() &&
                            ((ConfigTypeImpl)m_configType).hasInitialValues())
                        {
                            ((ConfigTypeImpl)m_configType).applyInitialValuesTo(m_bean);
                        }
                    }
                    else
                    {
                        m_bean = new ConfigBeanImpl(name, localName, version, (ConfigServer)m_configServer);
                    }

                    m_parentConfigObjects.push(m_bean);
                }
                catch (Exception e)
                {
                    throw new SAXException(e);
                }
            }
            else
            {
            	/*
            	 * Since we try to avoid schema changes for any SMC types, there no AttributeDescription 
            	 * for TOOL_ANNOTATION element
            	 */
            	if (localName.equals(IAnnotationExtension.TOOL_ANNOTATION))
            	{
            		isAnnotation = true;
            	}
            	else
            	{
	                /*  Get the attribute description of this config object's parent in order to
	                    retrieve this config objects attribute description.
	                */
	                IAttributeDescription parentAttrDesc = (IAttributeDescription) m_configObjectDescs.peek();
	
	                if (parentAttrDesc == null)
	                {
	                    throw new SAXException("Configuration bean document parser encountered an internal error while parsing configuration document '" + m_locator.getSystemId() + "' " +
	                                           "at line number '" + m_locator.getLineNumber() + "' " +
	                                           "column number '" + m_locator.getColumnNumber() + "' " +
	                                           ": An attribute description for the parent of the element '" + localName + "' does not exist.");
	                }
	
	                /*  Retrieve this config objects attribute description.
	                */
	                IAttributeDescription attrDesc = parentAttrDesc.getAttributeDescription(localName);
	                if (attrDesc == null)
	                {
	                    throw new SAXException("Configuration bean document parser encountered an internal error while parsing configuration document '" + m_locator.getSystemId() + "' " +
	                                           "at line number '" + m_locator.getLineNumber() + "' " +
	                                           "column number '" + m_locator.getColumnNumber() + "' " +
	                                           ": An attribute description for the element '" + localName + "' does not exist.");
	                }
	
	                /*  Push attribute description for config object onto description stack:
	                    This attribute description will be used by in the 'endElement' method
	                    to convert the XML element's character content into a runtime value
	                    for the config object.
	                */
	                m_configObjectDescs.push(attrDesc);
	
	                /*  If the config object is part of an unenumerated map, its name
	                    is specified in the 'name' attribute of the XML element.
	                */
	                if (parentAttrDesc.getProperty(IAttributeDescription.UNENUM_MAP_PROPERTY) != null)
	                {   /*  This attribute is an entry in an unenumerated
	                        attribute map: retrieve attribute name from 'name'
	                        xml attribute. */
	                    String name = null;
	                    int length = attributes.getLength();
	                    for (int i = 0; i < length; i++)
	                    {
	                        if(attributes.getLocalName(i).equals("name"))
	                        {
	                            name = attributes.getValue(i);
	                            break;
	                        }
	                    }
	
	                    if (name == null)
	                    {   /* Cannot store unamed attribute */
	                        throw new SAXException("Error in configuration document '" + m_locator.getSystemId() + "' " +
	                                               "at line number '" + m_locator.getLineNumber() + "' " +
	                                               "column number '" + m_locator.getColumnNumber() + "' " +
	                                               ": element '" + localName + "' in unenumerated attribute map does not have 'name' attribute defined.");
	                    }
	                    try
	                    {
	                        ((AttributeDescriptionImpl)attrDesc).setProperty(UNENUM_NAME, name);
	                    }
	                    catch (ConfigServiceException e)
	                    {
	                        throw new SAXException(e);
	                    }
	                }
	
	                if (attrDesc.getType().equals(IAttributeMap.class))
	                {   /*  Push attribute map onto parent config object stack
	                        so that its children can add themselves after they
	                        have been parsed.
	                    */
	                    AttributeMapImpl attrMap = new AttributeMapImpl(attrDesc);
	                    m_parentConfigObjects.push(attrMap);
	                }
	                else if (attrDesc.getType().equals(IAttributeList.class))
	                {   /*  Push attribute list onto parent config object stack
	                        so that its children can add themselves after they
	                        have been parsed.
	                    */
	                    AttributeListImpl attrList = new AttributeListImpl(attrDesc);
	                    m_parentConfigObjects.push(attrList);
	                }
	                else
	                {   /*  Create new String Buffer to accumulate elements content.
	                    */
	                    m_characterContent = new StringBuffer();
	
	                }
            	}
            }
        }

        @Override
        public void
        characters(char[] ch, int offset, int length)
        throws SAXException
        {
	        if(m_isCData)
	        {
	            m_contentCDATA.append(ch,offset,length);
	        } 
        	    
            if (m_characterContent != null)
            {   /*  accumulate */
                m_characterContent.append(ch, offset, length);
            }
        }
        
        /*
         *  (non-Javadoc)
         * @see org.xml.sax.ext.LexicalHandler#startCDATA()
         */
        @Override
        public void startCDATA() throws SAXException {
            m_isCData=true;
        }

        /*
         *  (non-Javadoc)
         * @see org.xml.sax.ext.LexicalHandler#endCDATA()
         */
        @Override
        public void endCDATA() throws SAXException {
            m_isCData = false;
            
            if(isAnnotation)
            {
            	m_bean.setAnnotation(m_contentCDATA.toString());
            }
            
            m_contentCDATA.setLength(0); //cleanup buffer    
        }
        
        /*
         * current implementation isn't required to hadle the following callbacks in LexicalHandler
         */
        @Override
        public void comment(char[] ch,int start,int length) throws SAXException {}

        @Override
        public void startDTD(java.lang.String name,java.lang.String publicId,java.lang.String systemId) throws SAXException{}
        
        @Override
        public void endDTD()throws SAXException {}
                
        @Override
        public void startEntity(java.lang.String name) throws SAXException {}
        
        @Override
        public void endEntity(java.lang.String name) throws SAXException {}
        
        
        @Override
        public void
        endElement(String uri, String localName, String qname)
        throws SAXException
        {
            Object configObject = null;

            if (localName.equals(IAnnotationExtension.TOOL_ANNOTATION))
        	{
        		isAnnotation = false;
        	}
            else
            {
	            /*  Pop config object's description off of stack. */
	            IAttributeDescription attrDesc = (IAttributeDescription) m_configObjectDescs.pop();
	
	            if (attrDesc.getType().equals(IAttributeMap.class))
	            {   /*  Map is on the config object stack. */
	                configObject = m_parentConfigObjects.pop();
	            }
	            else if (attrDesc.getType().equals(IAttributeList.class))
	            {   /*  List is on the config object stack. */
	                configObject = m_parentConfigObjects.pop();
	            }
	            else
	            {   /*  Create config object from element content. */
	                String content = m_characterContent.toString();
	                m_characterContent = null;
	
	                try
	                {   /*  Convert content into runtime value. */
	                    configObject = attrDesc.validate(content);
	                }
	                //catch (InvalidDatatypeValueException e)
	                catch (ConfigServiceException e)
	                {
	                    throw new SAXException(e);
	                }
	            }
	
	
	            /*  Add config object to parent element:
	                Get description of config object's parent off of stack. */
	            try
	            {
	                IAttributeDescription parentAttrDesc = (IAttributeDescription) m_configObjectDescs.peek();
	                if (parentAttrDesc.getType().equals(IAttributeMap.class))
	                {
	                    try
	                    {
	                        /*  Add config object to a map. */
	                        IAttributeMap attrMap = (IAttributeMap) m_parentConfigObjects.peek();
	                        String unenumName = (String) ((AttributeDescriptionImpl)attrDesc).removeProperty(UNENUM_NAME);
	                        if (unenumName != null)
	                        {   /*  Config object is part of an unenumerated map;
	                                name is specified by 'name' attribute stored
	                                in m_unenumName instead of by tag name.
	                            */
	                            attrMap.setAttribute(unenumName, configObject);
	                        }
	                        else
	                        {
	                            attrMap.setAttribute(localName, configObject);
	                        }
	                    }
	                    catch (ConfigServiceException e)
	                    {
	                        throw new SAXException(e);
	                    }
	                }
	                else if (parentAttrDesc.getType().equals(IAttributeList.class))
	                {
	                    try
	                    {
	                        /*  Add config object to a list. */
	                        IAttributeList attrList = (IAttributeList) m_parentConfigObjects.peek();
	                        attrList.addAttribute(configObject);
	                    }
	                    catch (ConfigServiceException e)
	                    {
	                        throw new SAXException(e);
	                    }
	                }
	                else
	                {
	                    throw new SAXException("Configuration bean document parser encountered an internal error while parsing configuration document '" + m_locator.getSystemId() + "' " +
	                                           "at line number '" + m_locator.getLineNumber() + "' " +
	                                           "column number '" + m_locator.getColumnNumber() + "' " +
	                                           ": element '" + localName + "' has unknown parent element type.");
	                }
	            }
	            catch (EmptyStackException e)
	            {
	                //  Processing endElement of Config Bean: no parent element.
	            }
            }
        }
    }

    private ConfigBeanDocument()
    {
    }

    public static IConfigBean
    parse(String beanDocumentURL, IConfigServer configServer)
    throws ConfigServiceException
    {
        return parse(beanDocumentURL, configServer, false);
    }

    public static IConfigBean
    parse(String beanDocumentURL, IConfigServer configServer, boolean replaceConfigBean)
    throws ConfigServiceException
        {
        try
        {
            Handler handler = new Handler(configServer, replaceConfigBean);

            XMLReader parser = XMLReaderFactory.createXMLReader(Util.DEFAULT_PARSER_NAME);
            
            parser.setContentHandler(handler);
            parser.setProperty(Util.LEXICAL_HANDLER_PROPERTY, handler);

            if (!beanDocumentURL.startsWith("file:"))
            {
                beanDocumentURL = "file:" + beanDocumentURL;
            }

            parser.parse(beanDocumentURL);

            return handler.m_bean;
        }
        catch (SAXException e)
        {
            Exception ex = e.getException();
            if (ex != null)
            {
                throw new ConfigServiceException("cbd-parse-failed", new Object[] { beanDocumentURL }, ex);
            }
            else
            {
                throw new ConfigServiceException("cbd-parse-failed", new Object[] { beanDocumentURL }, e);
            }
        }
        catch (Exception e)
        {
            throw new ConfigServiceException("cbd-parse-failed", new Object[] { beanDocumentURL }, e);
        }
    }
    
    public static String parseVersion(String typeURL)
    throws ConfigServiceException
    {
        try
        {
            VersionHandler handler = new VersionHandler();

            XMLReader parser = XMLReaderFactory.createXMLReader(Util.DEFAULT_PARSER_NAME);

            parser.setContentHandler(handler);

            if (!typeURL.startsWith("file:"))
            {
                typeURL = "file:" + typeURL;
            }

            parser.parse(typeURL);

            return handler.m_version;
        }
        catch (SAXException e)
        {
            Exception ex = e.getException();
            if (ex != null)
            {
                throw new ConfigServiceException("cbd-parse-version-failed", new Object[] { typeURL }, ex);
            }
            else
            {
                throw new ConfigServiceException("cbd-parse-version-failed", new Object[] { typeURL }, e);
            }
        }
        catch (Exception e)
        {
            throw new ConfigServiceException("cbd-parse-identity-failed", new Object[] { typeURL }, e);
        }
    }
    
    

    public static class ConfigBeanIdentity
    {
        public ConfigBeanIdentity(String name, String typeName, String version, String productVersion)
        {
            m_name = name;
            m_typeName = typeName;
            m_version = version;
            m_productVersion = productVersion;
        }

        @Override
        public String toString()
        {
            return "ConfigBeanIdentity { " + m_name + " [" + m_typeName + "," + m_version + "] }";
        }

        public final String m_name;
        public final String m_typeName;
        public final String m_version;
        public final String m_productVersion;
    }

    public static ConfigBeanIdentity
    parseIdentity(String beanDocumentURL)
    throws ConfigServiceException
    {
        try
        {
            IdentityHandler handler = new IdentityHandler();

            XMLReader parser = XMLReaderFactory.createXMLReader(Util.DEFAULT_PARSER_NAME);

            parser.setContentHandler(handler);

            if (!beanDocumentURL.startsWith("file:"))
            {
                beanDocumentURL = "file:" + beanDocumentURL;
            }

            parser.parse(beanDocumentURL);

            return new ConfigBeanIdentity(handler.m_name, handler.m_typeName, handler.m_version, handler.m_productVersion);
        }
        catch (SAXException e)
        {
            Exception ex = e.getException();
            if (ex != null)
            {
                throw new ConfigServiceException("cbd-parse-identity-failed", new Object[] { beanDocumentURL }, ex);
            }
            else
            {
                throw new ConfigServiceException("cbd-parse-identity-failed", new Object[] { beanDocumentURL }, e);
            }
        }
        catch (Exception e)
        {
            throw new ConfigServiceException("cbd-parse-identity-failed", new Object[] { beanDocumentURL }, e);
        }
    }

    public static ConfigBeanIdentity
    parseIdentityContent(String beanDocumentContents)
    throws ConfigServiceException
    {
        try
        {
            IdentityHandler handler = new IdentityHandler();

            XMLReader parser = XMLReaderFactory.createXMLReader(Util.DEFAULT_PARSER_NAME);

            parser.setContentHandler(handler);

            StringReader stringReader = new StringReader(beanDocumentContents);
            InputSource inputSource = new InputSource(stringReader);

            parser.parse(inputSource);

            return new ConfigBeanIdentity(handler.m_name, handler.m_typeName, handler.m_version, handler.m_productVersion);
        }
        catch (SAXException e)
        {
            Exception ex = e.getException();
            if (ex != null)
            {
                throw new ConfigServiceException("cbd-parse-identity-content-failed", ex);
            }
            else
            {
                throw new ConfigServiceException("cbd-parse-identity-content-failed", e);
            }
        }
        catch (Exception e)
        {
            throw new ConfigServiceException("cbd-parse-identity-content-failed", e);
        }
    }

    public static IConfigBean
    parseContent(String beanDocumentContents, IConfigServer configServer)
    throws ConfigServiceException
    {
        return parseContent(beanDocumentContents, configServer, false);
    }

    public static IConfigBean
    parseContent(String beanDocumentContents, IConfigServer configServer, boolean replaceConfigBean)
    throws ConfigServiceException
    {
        try
        {
            Handler handler = new Handler(configServer, replaceConfigBean);

            XMLReader parser = XMLReaderFactory.createXMLReader(Util.DEFAULT_PARSER_NAME);

            parser.setContentHandler(handler);

            StringReader stringReader = new StringReader(beanDocumentContents);
            InputSource inputSource = new InputSource(stringReader);

            parser.parse(inputSource);

            return handler.m_bean;
        }
        catch (SAXException e)
        {
            Exception ex = e.getException();
            if (ex != null)
            {
                throw new ConfigServiceException("cbd-parse-content-failed", ex);
            }
            else
            {
                throw new ConfigServiceException("cbd-parse-content-failed", e);
            }
        }
        catch (Exception e)
        {
            throw new ConfigServiceException("cbd-parse-content-failed", e);
        }
    }
}
