package com.sonicsw.mx.config.impl;

import java.io.InputStream;

import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;

import com.sonicsw.mf.common.dirconfig.IDirElement;

public class ConfigBeanFile
extends ConfigBeanImpl
implements IConfigBeanFile
{
    public static final String CONFIG_TYPE     = "MF_FILE";
    public static final String CONFIG_VERSION  = "100";
    public static final String PRODUCT_VERSION = "2.1";

    public static final IConfigPath CREATION_TIME      = ConfigFactory.createConfigPath("CREATION_TIME");
    public static final IConfigPath LAST_MODIFIED_TIME = ConfigFactory.createConfigPath("LAST_MODIFIED_TIME");
    public static final IConfigPath SIZE               = ConfigFactory.createConfigPath("SIZE");
    public static final IConfigPath CREATED_BY         = ConfigFactory.createConfigPath("CREATED_BY");
    public static final IConfigPath PERMISSIONS        = ConfigFactory.createConfigPath("PERMISSIONS");
    public static final IConfigPath HIDDEN             = ConfigFactory.createConfigPath("HIDDEN");

    public static final String IDENTITY_ELEMENT_TYPE_STRING = CONFIG_TYPE;

    protected ConfigBeanFile(IDirElement dsBeanElement, ConfigServer cs)
    throws ConfigServiceException
    {
        super(dsBeanElement, cs);
    }

    protected ConfigBeanFile(String name, String user, ConfigServer configServer)
    throws ConfigServiceException
    {
        super(name, CONFIG_TYPE, CONFIG_VERSION, configServer);

        Long timeNow = new Long(System.currentTimeMillis());

        setAttribute(CREATION_TIME, timeNow);
        setAttribute(LAST_MODIFIED_TIME, timeNow);
        setAttribute(SIZE, new Integer(0));
        setAttribute(CREATED_BY, (user != null) ? user : "");
        setAttribute(PERMISSIONS, "");
        setAttribute(HIDDEN, Boolean.FALSE);
    }

    @Override
    public IConfigPrototype
    createPrototype(String name)
    throws ConfigServiceException
    {
        throw new ConfigServiceException("cbf-create-proto-not-supported");
    }

    @Override
    public long
    getCreationTime()
    {
        return ((Long)getAttribute(CREATION_TIME)).longValue();
    }

    @Override
    public long
    getLastModifiedTime()
    {
        return ((Long)getAttribute(LAST_MODIFIED_TIME)).longValue();
    }

    @Override
    public String
    getCreateBy()
    {
        return (String) getAttribute(CREATED_BY);
    }

    @Override
    public int
    getFileSize()
    {
        return ((Integer)getAttribute(SIZE)).intValue();
    }

    @Override
    public void
    setContents(InputStream contents)
    throws ConfigServiceException
    {
        try
        {
            int size = contents.available();
            setInputStream(contents);
            setAttribute(SIZE, new Integer(size));
            setAttribute(LAST_MODIFIED_TIME, new Long(System.currentTimeMillis()));
        }
        catch (Exception e)
        {
            throw new ConfigServiceException("cbf-set-contents-failed",e);
        }
    }

    @Override
    public InputStream
    getContents()
    throws ConfigServiceException
    {
        return getInputStream();
    }

}