package com.sonicsw.mx.config.impl;

import java.util.HashSet;
import java.util.Set;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPrototype;

import com.sonicsw.mf.common.dirconfig.IDirElement;

/**
 * <p>Title: ConfigBeanPrototype</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author not attributable
 * @version 1.0
 */
public class ConfigBeanPrototype extends ConfigBeanImpl
                                 implements IConfigPrototype
{
    /**
     *
     * @param name
     * @param bean
     * @throws ConfigServiceException
     */
    protected ConfigBeanPrototype(String name, ConfigBeanImpl bean)
        throws ConfigServiceException
    {
        super(name, bean, true);
    }

    /**
     *
     * @param name
     * @param type
     * @param version
     * @param configServer
     * @throws ConfigServiceException
     */
    protected ConfigBeanPrototype(String name,
                                  String type,
                                  String version,
                                  ConfigServer configServer)
        throws ConfigServiceException
    {
        super(name, type, version, configServer);
    }

    /**
     *
     * @param dsElement
     * @param configServer
     * @throws ConfigServiceException
     */
    protected ConfigBeanPrototype(IDirElement dsElement,
                                  ConfigServer configServer)
        throws ConfigServiceException
    {
        super(dsElement, configServer);
    }

    /**
     *
     * @param name
     * @return
     * @throws ConfigServiceException
     */
    @Override
    public IConfigElement newInstance(String name)
        throws ConfigServiceException
    {
        return m_configServer.createBeanFromPrototype(this, name);
    }

    /**
     *
     * @param instance
     */
    protected void removeInstance(IConfigElement instance)
    {
    }

    /**
     *
     * @return
     * @throws ConfigServiceException
     */
    @Override
    public Set getSubElements()
        throws ConfigServiceException
    {
        Set subElements = super.getSubElements();
        subElements.addAll(getPrototypeInstances());
        return subElements;
    }

    /**
     *
     * @return
     * @throws ConfigServiceException
     */
    @Override
    public Set getPrototypeInstances()
        throws ConfigServiceException
    {
        HashSet res = new HashSet();
        String[] names = new String[0];

        try
        {
            if (!isNew())
            {
                IDirElement de = ((ConfigServer)getConfigServer()).loadDirElement(getName());

                names = de.getSubclassedList();
            }
        }
        catch (Exception e)
        {
            throw new ConfigServiceException("blah", e);
        }


        for (int i = 0; i < names.length; i++)
        {
            IConfigElement instance = getConfigServer().loadConfigElement(names[i]);

            if (instance != null)
            {
                res.add(instance);
            }
        }

        return res;
    }

}
