/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.ConfigServiceException;

import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementChangeHandler;
import com.sonicsw.mf.common.config.INameChangeHandler;
import com.sonicsw.mf.common.config.INamingNotification;

class ConfigChangeDispatcher implements IElementChangeHandler, INameChangeHandler
{
    protected ConfigServer m_cs;
    protected DispatcherModule[] m_modules = null;

    public ConfigChangeDispatcher(ConfigServer cs)
    {
       m_cs = cs;

       m_modules = new DispatcherModule[3];

       m_modules[0] = new CheckForEmptyDispatcherModule(m_cs);
       m_modules[1] = new CacheDispatcherModule(m_cs);
       m_modules[2] = new ReferenceDispatcherModule(m_cs);
    }

    public ConfigChangeDispatcher(ConfigServer cs, DispatcherModule[] modules)
    {
       m_cs       = cs;
       m_modules = modules;
    }

    protected void dispatch(ConfigChange configChange)
    {
        synchronized (m_cs)
        {
            boolean propagate = false;

            for (int i = 0; i < m_modules.length; i++)
            {
                propagate = m_modules[i].processConfigChange(configChange);

                if (!propagate)
                {
                    break;
                }
            }

            if (propagate)
            {
                m_cs.sendConfigChange(configChange);
            }
        }
    }

    @Override
    public void handleElementChange(IElementChange element)
    {
        synchronized(m_cs)
        {
            dispatch(new ConfigChange(element, null));
        }
    }

    @Override
    public void onNamingNotification(INamingNotification notification)
    {
        synchronized(m_cs)
        {
            try
            {
                dispatch(new ConfigChange(notification, null));
            }
            catch(ConfigServiceException e)
            {
            }
        }
    }
}
