/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;

import com.sonicsw.mf.common.config.Reference;

public class ConfigReference
extends Reference
{
    /** The config server in which the config element that this
     *  reference denotes resides.
     */
    protected IConfigServer m_configServer = null;

    /*  The config element that contains and owns this Reference.
     *  A config reference can reside within only one config element
     *  at a time.
     */
    protected IConfigElement m_owner = null;


    /** The config element to which this reference refers.
     *  This reference will be null until reference is resolved by invoking
     *  its getConfigElement method.
     */
    protected IConfigElement m_configElement = null;

    protected ConfigReference(String elementName, IConfigServer configServer)
    {
        super(elementName);
        if (configServer == null)
        {
            throw new IllegalArgumentException("Failed to create reference to config element: null config server reference.");
        }
        m_configServer = configServer;
    }

    protected ConfigReference(IConfigElement configElement)
    {
        super(configElement == null ?
                null :
                (configElement instanceof IConfigType) ?
                  ((ConfigTypeImpl)configElement).getDSName() :
                  configElement.getName()
              );

        m_configElement = configElement;
        if (configElement != null) {
        	m_configServer = configElement.getConfigServer();
        }
    }

    @Override
    public boolean
    equals(Object obj)
    {
        if (obj == null || this.getClass() != obj.getClass())
        {
            return false;
        }
        return getElementName().equals(((ConfigReference)obj).getElementName());
    }

    @Override
    public int
    hashCode()
    {
        return getElementName().hashCode();
    }

    public IConfigElement
    getConfigElement()
    throws ConfigServiceException
    {
        if (m_configElement == null)
        {
            m_configElement = m_configServer.loadConfigElement(getElementName());
        }
        return m_configElement;
    }

    public IConfigElement
    getLocalConfigElement()
    throws ConfigServiceException
    {
        if (m_configElement == null)
        {
            m_configElement = ((ConfigServer)m_configServer).loadConfigElement(getElementName(), true);
        }
        return m_configElement;
    }

    /** Return a reference to the config element that contains and owns this
     *  reference. If this reference is not contained in any config element,
     *  a <code>null</code> is returned.
     */
    public IConfigElement
    getOwner()
    {
        return m_owner;
    }

    /*  Set the owner of this map.
     *  The owner of this map must contain it.
     *  @exception  ConfigServiceException thrown if this map
     *              is already contained in another config element.
     */
    void
    setOwner(IConfigElement owner)
    throws ConfigServiceException
    {
        if (m_owner != null && owner != null)
        {
            throw new ConfigServiceException("Reference to config element can not be added to " + owner.getName() + ": reference is already contained within " + m_owner.getName() + ".");
        }

        if (owner != null && owner.getConfigServer() != m_configServer)
        {
            throw new ConfigServiceException("Reference to config element can not be added to " + owner.getName() + ": config element is stored in a different config server.");
        }

        m_owner = owner;
    }

    @Override
    public String
    toString()
    {
        return getElementName();
    }
}