/*
 * Copyright (c) 2004 Sonic Software Inc
 *
 * This software is the confidential and proprietary information of Sonic
 * Software. You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the source code
 * license agreement you entered into with Sonic Software.
 *
 */
package com.sonicsw.mx.config.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import com.sonicsw.mx.config.ConfigAttributeException;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IAttributeMetaData;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigChangeListener;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.security.ConfigurePermissionDeniedException;
import com.sonicsw.mf.common.security.IConfigurePermissionBits;

/**
 * @author <a href="mailto:murali@sonicsoftware.com">Murali Mohan</a>
 * @since: Jan 5, 2007
 */
public class IdentityOnlyConfigBeanImpl extends IdentityOnlyConfigBean {


    private static final IdentityOnlyConfigBeanImpl deniedBeanInstance = new IdentityOnlyConfigBeanImpl.UnidentifiableConfigBean();

    private String name;
    private IdentityOnlyConfigType configType;

    private static boolean _debug = Boolean.getBoolean("com.sonicsw.mx.config.IdentityOnlyConfigBean.debug");


    /**
     * If active, returns a newly created IdentityOnlyConfigBean or UnidentifiableConfigBean if the identity could not be
     * established.
     * Else returns null.
     * The client (SMC) should first activate by calling  IdentityOnlyConfigBean.activate(true);
     * @param server
     * @param reference
     * @return
     */
    static IConfigBean createIdentityOnlyConfigBean(ConfigServer server, ConfigReference reference) {
        if (IdentityOnlyConfigBean.isEnabled()) {
            try {
                IElementIdentity fsIdentity = server.m_ds.getFSIdentity(reference.getElementName());
                return new IdentityOnlyConfigBeanImpl(fsIdentity.getName(), fsIdentity.getType(), fsIdentity.getReleaseVersion());
            } catch (ConfigurePermissionDeniedException e) {
                if(IdentityOnlyConfigBean.unIndentifiable!=null)
                {
                    IdentityOnlyConfigBean.unIndentifiable = deniedBeanInstance;
                }
                return deniedBeanInstance;
            } catch (Exception e) {
                e.printStackTrace();
                // ignore
            }
        }
        return null;
    }

    private IdentityOnlyConfigBeanImpl(String name, String type, String version) {
        this.name = name;
        configType = new IdentityOnlyConfigType(type,version);
    }

    @Override
    public IConfigType getConfigType() {
        return configType;
    }

    @Override
    public boolean isRemoved() {
        unSupported(getName());
        return false;
    }

    @Override
    public boolean isModified() {
        unSupported(getName());
        return false;
    }

    @Override
    public boolean isNew() {
        unSupported(getName());
        return false;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) throws ConfigServiceException {
        unSupported(getName());
    }

    @Override
    public IConfigServer getConfigServer() {
        unSupported(getName());
        return null;
    }

    @Override
    public void refresh() throws ConfigServiceException {
        unSupported(getName());
    }

    @Override
    public void setInputStream(InputStream stream) throws ConfigServiceException {
        unSupported(getName());
    }

    @Override
    public InputStream getInputStream() throws ConfigServiceException {
        unSupported(getName());
        return null;
    }

    @Override
    public IConfigPath[] getReferences() throws ConfigServiceException {
        unSupported(getName());
        return new IConfigPath[0];
    }

    @Override
    public boolean isMetaAttributesModified() {
        unSupported(getName());
        return false;
    }

    @Override
    public HashMap getMetaAttributes() throws ConfigServiceException {
        unSupported(getName());
        return null;
    }

    @Override
    public void setMetaAttributes(HashMap attributes) {
        unSupported(getName());
    }

    @Override
    public boolean isPrototypeInstance() {
        unSupported(getName());
        return false;
    }

    @Override
    public IConfigPrototype getPrototype() {
        unSupported(getName());
        return null;
    }

    @Override
    public Object clonePrototypeInstance(String name) {
        unSupported(getName());
        return null;
    }

    @Override
    public void unshare() throws ConfigServiceException {
        unSupported(getName());
    }

    @Override
    public IConfigPrototype createPrototype(String name) throws ConfigServiceException {
        unSupported(getName());
        return null;
    }

    @Override
    public long getCreationTime() {
        unSupported(getName());
        return 0;
    }

    @Override
    public Object clone() {
        unSupported(getName());
        return null;
    }

    @Override
    public Object getAttribute(String attributeName) {
        unSupported(getName());
        return null;
    }

    @Override
    public IAttributeMetaData getAttributeMetaData(String attributeName) throws ConfigAttributeException {
        unSupported(getName());
        return null;
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) throws ConfigAttributeException {
        unSupported(getName());
    }

    @Override
    public Object removeAttribute(String attributeName) throws ConfigAttributeException {
        unSupported(getName());
        return null;
    }

    @Override
    public Object getAttribute(IConfigPath path) {
        unSupported(getName());
        return null;
    }

    @Override
    public IAttributeMetaData getAttributeMetaData(IConfigPath path) throws ConfigAttributeException {
        unSupported(getName());
        return null;
    }

    @Override
    public void setAttribute(IConfigPath path, Object attributeValue) throws ConfigAttributeException {
        unSupported(getName());
    }

    @Override
    public Object removeAttribute(IConfigPath path) throws ConfigAttributeException {
        unSupported(getName());
        return null;
    }

    @Override
    public IAttributeMap getAttributes(Set attributeNames) {
        unSupported(getName());
        return null;
    }

    @Override
    public void setAttributes(IAttributeMap attributes) throws ConfigAttributeException {
        unSupported(getName());
    }

    @Override
    public IAttributeMap removeAttributes(Set attributeNames) throws ConfigAttributeException {
        unSupported(getName());
        return null;
    }

    @Override
    public Set getAttributeNames() {
        unSupported(getName());
        return null;
    }

    @Override
    public IAttributeDescription getAttributeDescription() {
        unSupported(getName());
        return null;
    }

    @Override
    public IAttributeMap createAttributeMap(String name) throws ConfigAttributeException {
        unSupported(getName());
        return null;
    }

    @Override
    public IAttributeList createAttributeList(String name) throws ConfigAttributeException {
        unSupported(getName());
        return null;
    }

    @Override
    public void addConfigChangeListener(IConfigPath attributeName, IConfigChangeListener listener, Object handback) throws ConfigServiceException {
        unSupported(getName());
    }

    @Override
    public void removeConfigChangeListener(IConfigPath attributeName, IConfigChangeListener listener, Object handback) throws ConfigServiceException {
        unSupported(getName());
    }

    @Override
    public void validateComplete() throws ConfigAttributeException {
        unSupported(getName());
    }

    @Override
    public String toXML() {
        unSupported(getName());
        return null;
    }

    @Override
    public int size() {
        unSupported(getName());
        return 0;
    }

    @Override
    public boolean isEmpty() {
        unSupported(getName());
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        unSupported(getName());
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        unSupported(getName());
        return false;
    }

    @Override
    public Object get(Object key) {
        unSupported(getName());
        return null;
    }

    @Override
    public Object put(Object key, Object value) {
        unSupported(getName());
        return null;
    }

    @Override
    public Object remove(Object key) {
        unSupported(getName());
        return null;
    }

    @Override
    public void putAll(Map t) {
        unSupported(getName());
    }

    @Override
    public void clear() {
        unSupported(getName());
    }

    @Override
    public Set keySet() {
        unSupported(getName());
        return null;
    }

    @Override
    public Collection values() {
        unSupported(getName());
        return null;
    }

    @Override
    public Set entrySet() {
        unSupported(getName());
        return null;
    }

    /*
    * Sets annotation meta-data for ConfigBean
    *
    */
    @Override
    public void setAnnotation(String value) {
        unSupported(getName());
    }

    /*
    * Return ConfigBean annotatition meta-data
    */
    @Override
    public String getAnnotation() {
        unSupported(getName());
        return null;
    }

    @Override
    public String toString() {
        return getName();
    }

    @Override
    public boolean isUnidentifiable() {
        return false;
    }

    private static void unSupported(String target){
        if (_debug) {
            System.err.println("TROUBLE... " + IdentityOnlyConfigBeanImpl.class.getName() + ".unSupported(getName()) called.");
            Thread.dumpStack();
        }
        throw new ConfigurePermissionDeniedException("No permission to perform this operation",target, IConfigurePermissionBits.ALLOW_READ);
    }


    private static class  IdentityOnlyConfigType implements IConfigType {
        private String name;
        private String version;

        public IdentityOnlyConfigType(String type, String version) {
            this.name = type;
            this.version = version;
        }

        @Override
        public String getName() {
            return name;
        }

        @Override
        public IConfigType getSuper() {
            unSupported(getName());
            return null;
        }

        @Override
        public String getVersion() {
            return version;
        }

        @Override
        public String getDescription() {
            unSupported(getName());
            return null;
        }

        @Override
        public IConfigServer getConfigServer() {
            unSupported(getName());
            return null;
        }

        @Override
        public Object clone() {
            unSupported(getName());
            return null;
        }

        @Override
        public Class getType() {
            unSupported(getName());
            return null;
        }

        @Override
        public Object getProperty(String propertyName) {
            unSupported(getName());
            return null;
        }

        @Override
        public Set getPropertyNames() {
            unSupported(getName());
            return null;
        }

        @Override
        public IAttributeDescription getAttributeDescription(String attributeName) {
            unSupported(getName());
            return null;
        }

        @Override
        public IAttributeDescription getAttributeDescription(IConfigPath path) {
            unSupported(getName());
            return null;
        }

        @Override
        public Set getAttributeDescriptionNames() {
            unSupported(getName());
            return null;
        }

        @Override
        public Object validate(String value) throws ConfigServiceException {
            unSupported(getName());
            return null;
        }

        @Override
        public void validate(Object value) throws ConfigServiceException {
            unSupported(getName());
        }
    }

    private static class UnidentifiableConfigBean extends IdentityOnlyConfigBeanImpl {

        private static final String DEFAULT_TO_STRING = "<Permission Denied>";

        public UnidentifiableConfigBean() {
            super(null, null, null);
        }

        @Override
        public IConfigType getConfigType() {
            unSupported(getName());
            return super.getConfigType();
        }

        @Override
        public String getName() {
            return DEFAULT_TO_STRING;
        }

        @Override
        public String toString() {
            return DEFAULT_TO_STRING;
        }

        @Override
        public boolean isUnidentifiable() {
            return true;
        }
    }
}
