/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mx.config.impl;

import java.util.Collection;
import java.util.Iterator;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;

public class NameSetImpl
extends java.util.HashSet
{

    @Override
    public Object
    clone()
    {
        return super.clone();
    }

    /*
     *
     *  Methods overriding behavior in java.util.HashSet. This Prevents set
     *  values that are not Strings from being added to set.
     *
     */

    @Override
    public boolean
    add(Object element)
    throws ConfigServiceRuntimeException
    {
        try
        {
            return super.add(Util.validateAttributeName(element));
        }
        catch (ConfigServiceException e)
        {
            throw new ConfigServiceRuntimeException(e);
        }
    }

    @Override
    public boolean
    addAll(Collection collection)
    throws ConfigServiceRuntimeException
    {
        try
        {
            Iterator values = collection.iterator();
            while (values.hasNext())
            {
                super.add(Util.validateAttributeName(values.next()));
            }
            return true;
        }
        catch (ConfigServiceException e)
        {
            throw new ConfigServiceRuntimeException(e);
        }
    }

}