/*
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mx.config.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;

import com.sonicsw.mf.common.config.IAttributeSet;

/**
 *
 */
public class PropertyMapImpl
extends AttributeMapImpl
{
    public PropertyMapImpl(ConfigServer configServer)
    {
        super(configServer);
    }

    public PropertyMapImpl(IAttributeSet propSet, ConfigServer configServer)
    {
        super(propSet, configServer);
    }

    @Override
    public String
    toString()
    {
        return toString(0);
    }

    public String
    toString(int indent)
    {
        StringBuffer buffer = new StringBuffer();
        StringBuffer indentBuf = new StringBuffer();
        for (int i = 0; i < indent; i++)
        {
            indentBuf.append("    ");
        }
        String indentStr = indentBuf.toString();

        Iterator propertyNames = keySet().iterator();
        while (propertyNames.hasNext())
        {
            String propertyName = (String) propertyNames.next();
            Object propertyValue = getProperty(propertyName);

            String className = propertyValue.getClass().getName();
            String typeName  = className.substring(className.lastIndexOf(".") + 1);

            if (propertyValue instanceof IAttributeMap)
            {
                buffer.append(indentStr).append(propertyName + "  [" + typeName + "] =\n");
                buffer.append(indentStr).append("{\n");
                buffer.append(((AttributeMapImpl)propertyValue).toString(indent + 1, false));
                buffer.append(indentStr).append("}\n");
            }
            else
            if (propertyValue instanceof IAttributeList)
            {
                buffer.append(indentStr).append(propertyName + "  [" + typeName + "] =\n");
                buffer.append(indentStr).append("{\n");
                buffer.append(((AttributeListImpl)propertyValue).toString(indent + 1, false));
                buffer.append(indentStr).append("}\n");
            }
            else
            {
                buffer.append(indentStr).append(propertyName + "  [" + typeName + "] = " + Util.toString(propertyValue) + "\n");
            }
        }

        return buffer.toString();
    }

    @Override
    public Object
    clone()
    {
        return super.clone();
    }

    /**
     *
     */
    public Object
    getProperty(String propertyName)
    {
        return getAttribute(propertyName);
    }

    /**
     *
     */
    public void
    setProperty(String propertyName, Object propertyValue)
    throws ConfigServiceException
    {
        setAttribute(propertyName, propertyValue);
    }

    /**
     *
     */
    public Object
    removeProperty(String propertyName)
    throws ConfigServiceException
    {
        return removeAttribute(propertyName);
    }

    /**
     *
     */
    public Map
    getProperties(Set propertyNames)
    {
        Map map = new PropertyMapImpl(m_configServer);
        Iterator names = propertyNames.iterator();
        while (names.hasNext())
        {
            String name = (String) names.next();
            map.put(name,_get(name));
        }
        return map;
    }

    /**
     *
     */
    public void
    setProperties(PropertyMapImpl properties)
    throws ConfigServiceException
    {
        setAttributes((IAttributeMap)properties);
    }

    /**
     *
     */
    public Map
    removeProperties(Set propertyNames)
    throws ConfigServiceException
    {
        Map map = new PropertyMapImpl(m_configServer);
        Iterator names = propertyNames.iterator();
        while (names.hasNext())
        {
            String name = (String) names.next();
            Object attribute = remove(name);
            removeAttribute(name);
            map.put(name,attribute);
        }
        return map;
    }

    public Set
    getPropertyNames()
    {
        return (NameSetImpl) getAttributeNames();
    }

    @Override
    public Object
    get(Object key)
    {
        return super._get(key);
    }
}