package com.sonicsw.mx.config.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigPath;

public class ReferenceDispatcherModule
extends DispatcherModule
{
    public ReferenceDispatcherModule(ConfigServer cs)
    {
        super(cs);
    }

    @Override
    public boolean processConfigChange(ConfigChange configChange)
    {
        switch (configChange.getChangeType())
        {
        case ConfigChange.RENAME:
            try
            {
                /*  An element has been renamed in the DS:
                    Retrieve all references to it. */
                IConfigPath[] references = m_cs.getReferences(configChange.getNewName());
                Map configChanges = new HashMap();

                for (int i = 0; i < references.length; i++)
                {
                    String name = references[i].getFirstComponent();
                    ConfigElementImpl referringElement = (ConfigElementImpl) m_cs.getElementCache().lookup(name, "");
                    if (referringElement != null)
                    {   /*  Referring element has been loaded locally:
                            Fix up reference to renamed element. */
                        references[i].removeComponent(0);
                        ConfigReference reference = (ConfigReference) referringElement._get(references[i]);

                        if (reference.getElementName().equals(configChange.getName()))
                        {   /*  Reference attribute refers to renamed element by old name:
                                Modify reference to new name */
                            referringElement.setAttribute(references[i], new ConfigReference(configChange.getNewName(), m_cs));

                            /* Populate Config Change for Reference attribute change.  */
                            ConfigChange referringElementConfigChange = (ConfigChange) configChanges.get(name);
                            if (referringElementConfigChange == null)
                            {
                                referringElementConfigChange = new ConfigChange(name, -1, ConfigChange.ELEMENT_UPDATED);
                                configChanges.put(name, referringElementConfigChange);
                            }
                            referringElementConfigChange.getModifiedAttributeNames().add(references[i]);
                        }
                    }
                }

                Iterator it = configChanges.values().iterator();
                while (it.hasNext())
                {
                    m_cs.sendConfigChange((ConfigChange) it.next());
                }
            }
            catch (ConfigServiceException e)
            {
                /* ignore */
            }
            break;
        default:
            /* NOOP */
        }

        return true;
    }
}
