package com.sonicsw.mx.config.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigElement;

import com.sonicsw.mf.common.config.impl.DSTransaction;
import com.sonicsw.mf.common.config.query.Query;

public class SubTxnConfigServer
    extends TxnConfigServer
{
    TxnConfigServer m_cs;                              // Parent Config Server
    Map             m_createElements = new HashMap();

    SubTxnConfigServer(TxnConfigServer cs)
        throws ConfigServiceException
    {
        super(cs.m_ds);

        m_cs = cs;
    }

    @Override
    public void close()
        throws ConfigServiceException
    {
        super.close();

        if (m_createElements != null)
        {
            m_createElements.clear();
            m_createElements = null;
        }
    }

    @Override
    public IConfigElement loadConfigElement(String configElementName)
        throws ConfigServiceException
    {
        try
        {
            ConfigElementImpl configElement = (ConfigElementImpl) getElementCache().lookup(configElementName, "");
            if (configElement != null)
            {
                return configElement;
            }

            ConfigElementImpl configElementInParent = (ConfigElementImpl) m_cs.loadConfigElement(configElementName);
            if (configElementInParent != null)
            {
                configElement = (ConfigElementImpl) configElementInParent.clone(this, configElementInParent.getName());
                setState(configElementInParent.getState(), configElement);
            }
            return configElement;
        }
        catch (ConfigServiceException e)
        {
            throw new ConfigServiceException("cs-load-ce-failed", new Object[] { configElementName }, e);
        }
    }

    @Override
    public IConfigElement loadLocalConfigElement(String configElementName)
        throws ConfigServiceException
    {
        try
        {
            ConfigElementImpl configElement = (ConfigElementImpl) getElementCache().lookup(configElementName, "");
            if (configElement != null)
            {
                return configElement;
            }

            ConfigElementImpl configElementInParent = (ConfigElementImpl) m_cs.loadLocalConfigElement(configElementName);
            if (configElementInParent != null)
            {
                configElement = (ConfigElementImpl) configElementInParent.clone(this, configElementInParent.getName());
                setState(configElementInParent.getState(), configElement);
            }
            return configElement;
         }
        catch (ConfigServiceException e)
        {
            throw new ConfigServiceException("cs-load-ce-failed", new Object[] { configElementName }, e);
        }
   }

    @Override
    public Set loadConfigElements(Query query)
        throws ConfigServiceException
    {
        try
        {
            Set configElements = new HashSet();
            Set configElementsInParent =  m_cs.loadConfigElements(query);
            Iterator it = configElementsInParent.iterator();
            while (it.hasNext())
            {
                ConfigElementImpl configElementInParent = (ConfigElementImpl) it.next();
                ConfigElementImpl configElement = (ConfigElementImpl) configElementInParent.clone(this, configElementInParent.getName());
                setState(configElementInParent.getState(), configElement);
                configElements.add(configElement);
            }
            return configElements;
        }
        catch (ConfigServiceException e)
        {
            throw new ConfigServiceException("cs-load-ces-failed", e);
        }
    }

    @Override
    public synchronized void commit()
        throws ConfigServiceException
    {
        try
        {
            synchronized (m_cs)
            {
                // Validate new, modified and unmodified config elements
                Iterator it = m_newElements.iterator();
                while (it.hasNext())
                {
                    ConfigElementImpl configElement = (ConfigElementImpl) it.next();
                    configElement.validateComplete();
                }
                it = m_modifiedElements.iterator();
                while (it.hasNext())
                {
                    ConfigElementImpl configElement = (ConfigElementImpl) it.next();
                    configElement.validateComplete();
                }
                it = m_unmodifiedElements.iterator();
                while (it.hasNext())
                {
                    ConfigElementImpl configElement = (ConfigElementImpl) it.next();
                    configElement.validateComplete();
                }

                it = m_txn.getActions().iterator();
                while (it.hasNext())
                {
                    DSTransaction.Action action = (DSTransaction.Action) it.next();
                    if (action instanceof DSTransaction.AttachBlob)
                    {

                    }
                    else
                    if (action instanceof DSTransaction.CreateElement)
                    {
                        DSTransaction.CreateElement createElement = (DSTransaction.CreateElement) action;
                        ConfigElementImpl configElement = (ConfigElementImpl) m_createElements.get(createElement.m_element.getIdentity().getName());
                        if (configElement != null)
                        {
                            ConfigElementImpl parentConfigElement = (ConfigElementImpl) configElement.clone(m_cs, configElement.getName());
                            if (configElement.m_blob != null)
                            {
                                parentConfigElement.setInputStream(configElement.m_blob);
                            }
                            if (configElement.isMetaAttributesModified())
                            {
                                parentConfigElement.setMetaAttributes(configElement.getMetaAttributes());
                            }
                            m_cs.storeConfigElement(parentConfigElement);
                        }
                    }
                    else
                    if (action instanceof DSTransaction.CreateFolder)
                    {
                        DSTransaction.CreateFolder createFolder = (DSTransaction.CreateFolder) action;
                        m_cs.createFolder(createFolder.m_folderName);
                    }
                    else
                    if (action instanceof DSTransaction.DeleteElement)
                    {
                        DSTransaction.DeleteElement deleteElement = (DSTransaction.DeleteElement) action;
                        m_cs.removeConfigElement(deleteElement.m_elementName);
                    }
                    else
                    if (action instanceof DSTransaction.DeleteFolder)
                    {
                        DSTransaction.DeleteFolder deleteFolder = (DSTransaction.DeleteFolder) action;
                        m_cs.deleteFolder(deleteFolder.m_folderName);
                    }
                    else
                    if (action instanceof DSTransaction.DetachBlob)
                    {

                    }
                    else
                    if (action instanceof DSTransaction.Rename)
                    {
                        DSTransaction.Rename rename = (DSTransaction.Rename) action;
                        ConfigElementImpl configElement = (ConfigElementImpl) m_cs.loadConfigElement(rename.m_oldName);
                        if (configElement != null)
                        {
                            configElement.setName(rename.m_newName);
                        }
                    }
                    else
                    if (action instanceof DSTransaction.SetAttributes)
                    {
                        DSTransaction.SetAttributes setAttributes = (DSTransaction.SetAttributes) action;
                        m_cs.setMetaAttributes(setAttributes.m_name, setAttributes.m_attributes);
                    }
                    else
                    if (action instanceof DSTransaction.UpdateElement)
                    {

                    }
                }

                // Merge modified elements into parent config server and
                // transition MODIFIED element to UNMODIFIED state
                Object[] objs = m_modifiedElements.toArray();
                for(int i = 0; i < objs.length; i++)
                {
                    ConfigElementImpl configElement = (ConfigElementImpl) objs[i];
                    ConfigElementImpl configElementInParent = (ConfigElementImpl) m_cs.loadConfigElement(configElement.getName());
                    if (configElementInParent != null)
                    {
                        configElementInParent.clear();
                        configElementInParent.putAll(configElement);
                    }
                    else
                    {
                        // element has been removed from parent: recreate it
                        ConfigElementImpl parentConfigElement = (ConfigElementImpl) configElement.clone(m_cs, configElement.getName());

                        if (configElement.m_blob != null)
                        {
                            parentConfigElement.setInputStream(configElement.m_blob);
                        }

                        if (configElement.isMetaAttributesModified())
                        {
                            parentConfigElement.setMetaAttributes(configElement.getMetaAttributes());
                        }
                    }
                }

                // Merge unmodified elements into parent config server
                objs = m_unmodifiedElements.toArray();
                for(int i = 0; i < objs.length; i++)
                {
                    ConfigElementImpl configElement = (ConfigElementImpl) objs[i];
                    ConfigElementImpl configElementInParent = (ConfigElementImpl) m_cs.loadConfigElement(configElement.getName());
                    if (configElementInParent != null)
                    {
                        configElementInParent.clear();
                        configElementInParent.putAll(configElement);
                    }
                    else
                    {
                        // element has been removed from parent: recreate it
                        ConfigElementImpl parentConfigElement = (ConfigElementImpl) configElement.clone(m_cs, configElement.getName());

                        if (configElement.m_blob != null)
                        {
                            parentConfigElement.setInputStream(configElement.m_blob);
                        }

                        if (configElement.isMetaAttributesModified())
                        {
                            parentConfigElement.setMetaAttributes(configElement.getMetaAttributes());
                        }
                    }
                }

                // Transition NEW element to UNMODIFIED state
                objs = m_newElements.toArray();
                for(int i = 0; i < objs.length; i++)
                {
                    elementStored((ConfigElementImpl)objs[i]);
                }

                // Transition MODIFIED element to UNMODIFIED state
                objs = m_modifiedElements.toArray();
                for(int i = 0; i < objs.length; i++)
                {
                    elementStored((ConfigElementImpl)objs[i]);
                }

                // Transition  REMOVED element to DELETED state
                objs = m_removedElements.toArray();
                for(int i = 0; i < objs.length; i++)
                {
                    elementDeleted(((ConfigElementImpl)objs[i]).getName());
                }

                m_txn = (DSTransaction) m_ds.createTransaction();
                m_createElements.clear();
            }
        }
        catch (Exception e)
        {
            try { rollback(); } catch (ConfigServiceException ex) { /* Ignore */ }
            throw new ConfigServiceException("tcs-commit-failed", e);
        }
    }

    @Override
    public synchronized void rollback()
        throws ConfigServiceException
    {
        Exception ex = null;

        synchronized (m_cs)
        {
            // Transition LOCAL elements to DELETED state
            Object[] objs = m_localElements.toArray();
            for(int i = 0; i < objs.length; i++)
            {
                elementDeleted((ConfigElementImpl)objs[i]);
            }

            // Transition NEW elements to DELETED state
            objs = m_newElements.toArray();
            for(int i = 0; i < objs.length; i++)
            {
                elementDeleted((ConfigElementImpl)objs[i]);
            }

            // Refresh MODIFIED elements from parent config server
            objs = m_modifiedElements.toArray();
            for(int i = 0; i < objs.length; i++)
            {
                ConfigElementImpl configElement = (ConfigElementImpl) objs[i];

                ConfigElementImpl configElementInParent = null;
                try
                {
                    configElementInParent = (ConfigElementImpl) m_cs.loadConfigElement(configElement.getName());
                }
                catch (ConfigServiceException e)
                {
                    ex = e;
                }

                if (configElementInParent != null)
                {
                    configElement.clear();
                    configElement.putAll(configElementInParent);
                    elementRefreshed(configElement);
                }
                else
                {   // element has been removed from parent: remove it
                    elementDeleted(configElement);
                }
            }

            // Refresh UNMODIFIED elements from parent config server
            objs = m_unmodifiedElements.toArray();
            for(int i = 0; i < objs.length; i++)
            {
                ConfigElementImpl configElement = (ConfigElementImpl) objs[i];

                ConfigElementImpl configElementInParent = null;
                try
                {
                    configElementInParent = (ConfigElementImpl) m_cs.loadConfigElement(configElement.getName());
                }
                catch (ConfigServiceException e)
                {
                    ex = e;
                }

                if (configElementInParent != null)
                {
                    configElement.clear();
                    configElement.putAll(configElementInParent);
                    elementRefreshed(configElement);
                }
                else
                {   // element has been removed from parent: remove it
                    elementDeleted(configElement);
                }
            }

            // Put REMOVED elements back into element cache and
            // refresh elements from parent config server
            objs = m_removedElements.toArray();
            for(int i = 0; i < objs.length; i++)
            {
                ConfigElementImpl configElement = (ConfigElementImpl) objs[i];
                getElementCache().add(configElement.getName(), "", configElement);

                ConfigElementImpl configElementInParent = null;
                try
                {
                    configElementInParent = (ConfigElementImpl) m_cs.loadConfigElement(configElement.getName());
                }
                catch (ConfigServiceException e)
                {
                    ex = e;
                }

                if (configElementInParent != null)
                {
                    configElement.clear();
                    configElement.putAll(configElementInParent);
                    elementRefreshed(configElement);
                }
                else
                {   // element has been removed from parent: remove it
                    elementDeleted(configElement);
                }
            }

        }

        m_txn = (DSTransaction) m_ds.createTransaction();
        m_createElements.clear();

        if (ex != null)
        {
            throw new ConfigServiceException("tcs-rollback-failed", ex);
        }
    }

    @Override
    public void flush()
        throws ConfigServiceException
    {
        super.flush();
        m_createElements.clear();
    }

    @Override
    protected void elementCreated(ConfigElementImpl configElement)
        throws ConfigServiceException
    {
        super.elementCreated(configElement);
        m_createElements.put(configElement.getDirectoryElementName(), configElement);
    }

    private void setState(short state, ConfigElementImpl configElement)
        throws ConfigServiceException
    {
        switch (state)
        {
            case ConfigElementImpl.NEW_STATE:
                /* NOOP */
                break;
            case ConfigElementImpl.MODIFIED_STATE:
                configElement.setState(ConfigElementImpl.MODIFIED_STATE);
                elementModified(configElement);
                break;
            case ConfigElementImpl.UNMODIFIED_STATE:
                elementRefreshed(configElement);
                break;
            case ConfigElementImpl.REMOVED_STATE:
                elementRemoved(configElement);
                break;
            case ConfigElementImpl.DELETED_STATE:
                elementDeleted(configElement);
                break;
        }
    }
}
