package com.sonicsw.mx.config.tools;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigType;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class GenerateBeanProperties extends ConfigServerUtility
{
    private static final String DEFAULT_URL       = "localhost";
    private static final String DEFAULT_USER      = "Administrator";
    private static final String DEFAULT_PASSWORD  = "Administrator";        //NOSONAR field change is not required.
    private static final String DEFAULT_DOMAIN    = "Domain1";
    private static final String DEFAULT_CVERSION  = "100";


    private ArrayList m_argList        = new ArrayList();
    private String    m_url            = DEFAULT_URL;
    private String    m_user           = DEFAULT_USER;
    private String    m_password       = DEFAULT_PASSWORD;
    private String    m_domain         = DEFAULT_DOMAIN;
    private String    m_cVersion       = DEFAULT_CVERSION;
    private String    m_output         = null; //"C:\\vobs_main601\\vobs_mgmt\\bin"; //temporary
    private boolean   m_merge          = false;
    private String    m_type           = null;
    private boolean   m_tooltip        = false;

    private PrintWriter m_propWriter;  // Writer for the property file

    private HashMap m_mergeProperties = new HashMap();


    public GenerateBeanProperties(String[] args)
    throws Exception
    {
       try
       {
           parseArgs(args);
       }
       catch(Exception e)
       {
           printUsage();

           throw e;
       }

       connect(m_domain, m_url, m_user, m_password, false);
       generate();
       cleanup();
    }

    private void generate() throws Exception
    {
        String[] types = _split(m_type, ","); // m_type.split(",");  <= jdk1.4

        for (int i = 0; i < types.length; i++)
        {
            generateFile(types[i]);
        }
    }

    private void generateFile(String type) throws Exception
    {

        if (m_merge)
        {
            loadProperties(type);
        }
        String propFilename = m_output + File.separator + type + ".properties";
        m_propWriter = new PrintWriter(new FileWriter(propFilename));

        IConfigType typeConfig = getConfigServer().loadConfigType(type, m_cVersion);

        if (type == null)
        {
            throw new Exception("Failed to load config type " + type + " " + m_cVersion);
        }

        for(Iterator iter = typeConfig.getAttributeDescriptionNames().iterator(); iter.hasNext(); )
        {
           String key = (String)iter.next();
           IAttributeDescription desc = typeConfig.getAttributeDescription(key);

           if(desc.getType() == IAttributeMap.class || desc.getType() == IAttributeList.class)
           {
               if(isMerged() && containsKey(type, key))
               {
                   mergePropertyValue(key, getProperty(type, key));

                   if (m_tooltip && containsKey(type, key + ".tooltip"))
                {
                    mergePropertyValue(key + ".tooltip", getProperty(type, key + ".tooltip"));
                }
               }
               else
               {
                   println(m_propWriter, 0, key + " = ");
                   if (m_tooltip)
                {
                    println(m_propWriter, 0, key + ".tooltip = ");
                }
               }
               generateKey(desc, key, type);
           }
           else
           {
               if (isMerged() && containsKey(type, key))
               {
                   mergePropertyValue(key, getProperty(type, key));

                   if(m_tooltip && containsKey(type, key + ".tooltip"))
                {
                    mergePropertyValue(key + ".tooltip", getProperty(type, key + ".tooltip"));
                }
               }
               else
               {
                   println(m_propWriter, 0, key + " = ");
                   if (m_tooltip)
                {
                    println(m_propWriter, 0, key + ".tooltip = ");
                }
               }
           }
        }

        if (m_propWriter != null)
        {
            m_propWriter.flush();
            m_propWriter.close();
        }

    }

    private void generateKey(IAttributeDescription descrAttr, String name, String type)
    {

        for(Iterator iter = descrAttr.getAttributeDescriptionNames().iterator(); iter.hasNext(); )
        {
            String key = (String)iter.next();
            IAttributeDescription desc = descrAttr.getAttributeDescription(key);
            if(desc.getType() == IAttributeMap.class || desc.getType() == IAttributeList.class)
            {
                if(isMerged() && containsKey(type, name + "." + key))
                {
                    mergePropertyValue(name + "." + key, getProperty(type, name + "." + key));

                    if (m_tooltip && containsKey(type, name + "." + key + ".tooltip"))
                    {
                        mergePropertyValue(name + "." + key + ".tooltip",getProperty(type, name + "." + key + ".tooltip"));
                    }
                }
                else
                {
                    println(m_propWriter, 0, name + "." + key + " = ");
                    if (m_tooltip)
                    {
                        println(m_propWriter, 0, name + "." + key + ".tooltip = ");
                    }
                }
                generateKey(desc, name + "." + key, type);
            }
            else
            {
               if(isMerged() && containsKey(type, name + "." + key))
               {
                   mergePropertyValue(name + "." + key, getProperty(type, name + "." + key));

                   if(m_tooltip && containsKey(type, name + "." + key + ".tooltip"))
                {
                    mergePropertyValue(name + "." + key + ".tooltip", getProperty(type, name + "." + key + ".tooltip"));
                }
               }
               else
               {
                   println(m_propWriter, 0, name + "." + key + " = ");
                   if (m_tooltip)
                {
                    println(m_propWriter, 0, name + "." + key + ".tooltip = ");
                }
               }
            }

        }

    }

    private void parseArgs(String[] args)
    throws Exception
    {
        int         i   = 0;

        while(i < args.length)
        {
            if(args[i].trim().length() == 0)
            {
                i++;
                continue;
            }

            if(args[i].equals("-url"))
            {
                m_url = args[++i];
            }
            else if(args[i].equals("-user"))
            {
                m_user = args[++i];
            }
            else if(args[i].equals("-password"))
            {
                m_password = args[++i];
            }
            else if(args[i].equals("-domain"))
            {
                m_domain = args[++i];
            }
            else if(args[i].equals("-output"))
            {
                m_output = args[++i];
            }
            else if(args[i].equals("-type"))
            {
                m_type = args[++i];
            }
            else if(args[i].equals("-cVersion"))
            {
                m_cVersion = args[++i];
            }
            else if(args[i].equals("-merge"))
            {
                m_merge = new Boolean(args[++i]).booleanValue();
            }
            else if(args[i].equals("-tooltip"))
            {
                m_tooltip =  new Boolean(args[++i]).booleanValue();
            }
            else
            {
                throw new Exception("Unsupported argument " + args[i]);
            }

            i++;
        }

        if (m_output == null)
        {
            throw new Exception("'output' is not specified");
        }
        if (m_type == null)
        {
            throw new Exception("'type' is not specified");
        }
    }

    private void loadProperties(String type)
    throws Exception
    {
        String propFilename = m_output + File.separator + type + ".properties";
        Properties property = new Properties();
        FileInputStream in = new FileInputStream(new File(propFilename));
        property.load(in);
        in.close();

        m_mergeProperties.put(type, property);
    }

    private boolean containsKey(String type, String key)
    {
        boolean result = false;
        Properties property = (Properties)m_mergeProperties.get(type);
        if (property != null)
        {
            result = property.containsKey(key);
        }
        return result;
    }

    private String getProperty(String type, String key)
    {
        String value = null;

        Properties property = (Properties)m_mergeProperties.get(type);
        if (property != null)
        {
            value = property.getProperty(key);
        }

        return value;
    }

    private void mergePropertyValue(String key, String value)
    {
        if (value == null)
        {
            return;
        }

        value = _replaceAll(value, "\\=", "\\\\="); // value.replaceAll("\\=", "\\\\="); //escape all = founded in attribute description
        value = _replaceAll(value, "\\:", "\\\\:"); // value.replaceAll("\\:", "\\\\:"); //escape all : founded in attribute description

        String[] result = _split(value, "\n"); //value.split("\n"); <= jdk1.4

        if (result.length == 1)
        {
            println(m_propWriter, 0, key + " = " + result[0]); // one line text
            return;
        }

        for (int i = 0; i < result.length; i++)
        {
            if (i == result.length - 1)
            {
                println(m_propWriter, key.length() + 3, result[i]); //last line
            }
            else
            {
                if (i == 0)
                {
                    println(m_propWriter, 0, key + " = " + result[i] + " \\n\\"); //first line
                }
                else
                {
                    println(m_propWriter, key.length() + 3, result[i] + " \\n\\");
                }
            }
        }
    }

    private void println(PrintWriter writer, int indent, String text)
    {
        for(int i = 0; i < indent; i++)
        {
            writer.print(" ");
        }

        writer.println(text);
    }


    private boolean isMerged()
    {
        return (m_merge && (!m_mergeProperties.isEmpty()));
    }

    private void cleanup()
    {
        if (!m_mergeProperties.isEmpty())
        {
            m_mergeProperties.clear();
        }
        m_mergeProperties = null;
    }

    private void printUsage()
    {
        System.out.println("com.sonicsw.mf.gui.config.tools.GenerateBeanProperties");
        System.out.println("    [-url <DS URL>]                                (Default = " + DEFAULT_URL + ")");
        System.out.println("    [-user <DS user name>]                         (Default = " + DEFAULT_USER + ")");
        System.out.println("    [-password <DS password>]                      (Default = " + DEFAULT_PASSWORD + ")");
        System.out.println("    [-domain <DS domain>]                          (Default = " + DEFAULT_DOMAIN + ")");
        System.out.println("    [-cVersion <config version>]                   (Default = " + DEFAULT_CVERSION + ")");
        System.out.println("    [-merge <merge keys if javadoc file exists>]   (Default = false");
        System.out.println("    [-tooltip, <generate key for tooltip>]         (Default = false)");
        System.out.println("    [-output <path to the javadoc file>]           (Default = None)");

        System.out.println("    [-type <config type name, or comma-separated types list>]  (Default = None)");

    }

    //-------------------------------------------------------------------------
    //
    // jdk1.4 compatibility methods
    //
    //-------------------------------------------------------------------------

    /**
     * Not really a substitute for the 1.4 split method because this implementation
     * interprets the regex parameter as a delimiter.
     *
     * @param str
     * @param regex
     * @return
     */
    private String[] _split(String str, String regex)
    {
        StringTokenizer st = new StringTokenizer(str, regex);
        ArrayList list = new ArrayList();

        while (st.hasMoreTokens())
        {
            list.add(st.nextToken());
        }

        return (String[])list.toArray(new String[list.size()]);
    }

    /**
     * Not really a substitute for the 1.4 replaceAll method because this
     * implementation interprets the regex parameter as a search string rather
     * than a 1.4-based regex.
     *
     * @param str
     * @param regex
     * @param replacement
     * @return
     */
    private String _replaceAll(String str, String regex, String replacement)
    {
        StringBuffer sb = new StringBuffer();
        int index = 0;

        do
        {
            int newIndex = str.indexOf(regex, index);

            if (newIndex == -1)
            {
                sb.append(str.substring(index));
                index = newIndex;
            }
            else
            {
                sb.append(str.substring(index, newIndex));
                sb.append(replacement);

                index = newIndex + regex.length();
            }
        }
        while (index != -1);

        return sb.toString();
    }

    //-------------------------------------------------------------------------

    public static void main(String[] args)
    {
        try
        {
            GenerateBeanProperties bean = new GenerateBeanProperties(args);

            bean.disconnect();
        }
        catch(Exception e)
        {
            System.out.println(e.getMessage());

            while(e != null && e instanceof ConfigServiceException)
            {
                e = ((ConfigServiceException)e).getLinkedException();

                if(e != null)
                {
                    System.out.println(e.getMessage());
                }
            }

            System.exit(-1);
        }
        System.exit(0);
    }

}