/*
 * Copyright (c) 1999-2000 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Sonic Software Corporation. ("Confidential Information"). You
 * shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you
 * entered into with Sonic Software.
 *
 * SONIC SOFTWARE MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. PROGRESS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 *
 */

package com.sonicsw.mx.config.tools.admin;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;

import javax.management.ObjectName;

import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;

public class DSDumper
{
    private static final String DEFAULT_URL       = "localhost";
    private static final String DEFAULT_USER      = "Administrator";
    private static final String DEFAULT_PASSWORD  = "Administrator";        //NOSONAR field change is not required.
    private static final String DEFAULT_DOMAIN    = "Domain1";
    private static final String DEFAULT_DIRECTORY = "/";

    private String m_url       = DEFAULT_URL;
    private String m_user      = DEFAULT_USER;
    private String m_password  = DEFAULT_PASSWORD;      //NOSONAR field change is not required.
    private String m_domain    = DEFAULT_DOMAIN;
    private String m_directory = DEFAULT_DIRECTORY;
    private String m_file      = null;

    public DSDumper(String[] args) throws Exception
    {
        parseArgs(args);

        System.out.println("Dump the contents of a DS directory:");
        System.out.println("    Broker URL  = " + m_url);
        System.out.println("    User        = " + m_user);
        System.out.println("    Password    = " + m_password);
        System.out.println("    Domain      = " + m_domain);
        System.out.println("    Directory   = " + m_directory);
        System.out.println("    Output File = " + ((m_file == null) ? "System.out" : m_file));

        JMSConnectorClient connector = new JMSConnectorClient();

        Hashtable env = new Hashtable();
        env.put("ConnectionURLs", m_url);
        env.put("DefaultUser",      m_user);
        env.put("DefaultPassword",  m_password);

        connector.connect(new JMSConnectorAddress(env));
        DirectoryServiceProxy dsProxy =
            new DirectoryServiceProxy(connector, new ObjectName(m_domain + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE"));

        String dump = null;

        try
        {
            dump = dsProxy.exportDirectoryToXML(m_directory);
        }
        catch(Exception e)
        {
            dump = dsProxy.exportElementToXML(m_directory);
        }

        Writer writer = null;

        if(m_file != null)
        {
            writer = new FileWriter(m_file);
        }
        else
        {
            writer = new PrintWriter(System.out);
        }

        writer.write(dump);
        writer.flush();
        writer.close();
    }

    private void parseArgs(String[] args) throws Exception
    {
        int i = 0;

        while(i < args.length)
        {
            if(args[i].equals("-url"))
            {
                m_url = args[++i];
            }
            else if(args[i].equals("-user"))
            {
                m_user = args[++i];
            }
            else if(args[i].equals("-password"))
            {
                m_password = args[++i];
            }
            else if(args[i].equals("-domain"))
            {
                m_domain = args[++i];
            }
            else if(args[i].equals("-directory"))
            {
                m_directory = args[++i];
            }
            else if(args[i].equals("-file"))
            {
                m_file = args[++i];
            }
            else
            {
                throw new Exception("Invalid argument " + args[i]);
            }

            i++;
        }
    }

    private static void printUsage()
    {
        System.out.println("com.sonicsw.mx.config.tools.admin.DSDumper ");
        System.out.println("    [-url url]             (Default = " + DEFAULT_URL + ")");
        System.out.println("    [-user user]           (Default = " + DEFAULT_USER + ")");
        System.out.println("    [-password password]   (Default = " + DEFAULT_PASSWORD + ")");
        System.out.println("    [-domain domain]       (Default = " + DEFAULT_DOMAIN + ")");
        System.out.println("    [-directory directory] (Default = " + DEFAULT_DIRECTORY + ")");
        System.out.println("    [-file filename]       (Default = System.out)");
    }

    public static void main(String[] args)
    {
        try
        {
            new DSDumper(args);
        }
        catch (Exception e)
        {
            System.out.println(e.toString());

            printUsage();
        }
        System.exit(0);
    }
}