package com.sonicsw.mx.config.tools.admin;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.management.ObjectName;

import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;

public class DSImporter
{
    private static final String OBJNAME           = ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE";
    private static final String DEFAULT_URL       = "localhost";
    private static final String DEFAULT_USER      = "Administrator";
    private static final String DEFAULT_PASSWORD  = "Administrator";        //NOSONAR field change is not required.
    private static final String DEFAULT_DOMAIN    = "Domain1";

    private String m_url      = DEFAULT_URL;
    private String m_user     = DEFAULT_USER;
    private String m_password = DEFAULT_PASSWORD;
    private String m_domain   = DEFAULT_DOMAIN;
    private Vector m_files    = new Vector();

    private DirectoryServiceProxy m_dsProxy   = null;
    private JMSConnectorClient    m_connector = null;

    public DSImporter(String [] args)
    {
        try
        {
            // Parse command line arguments
            parseArgs(args);

            // Create Broker Connection
            m_connector = createConnectorClient();

            // The management name of the directory service varies only by the domain it resides in.
            // Create a proxy to the Directory Service using the established connection
            m_dsProxy = new DirectoryServiceProxy(m_connector, new ObjectName(m_domain + OBJNAME));

            // Import files into the DS
            importFiles();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        finally
        {
            if(m_connector != null)
            {
                m_connector.disconnect();
            }
        }
    }

    private JMSConnectorClient createConnectorClient() throws Exception
    {
        Hashtable env = new Hashtable();
        env.put("ConnectionURLs",   m_url);
        env.put("DefaultUser",      m_user);
        env.put("DefaultPassword",  m_password);

        // create a JMX/JMS connection to the SonicMQ broker used for
        // management communications
        JMSConnectorAddress address = new JMSConnectorAddress(env);

        m_connector = new JMSConnectorClient();
        m_connector.connect(address);

        return m_connector;
    }

    private void importFiles()
    {
        try
        {
            for (int i =0; i < m_files.size();i++)
            {
                m_dsProxy.importFromXML(readFile((String)m_files.get(i)));
            }
        }
        catch(Exception e)
        {
            System.out.println("Warning: Failed to import file: " + e.getMessage());
        }
    }

    public String readFile(String file) throws Exception
    {
        String         contents = null;
        BufferedReader reader   = null;
        StringWriter   writer   = null;

        try
        {
            reader = new BufferedReader(new FileReader(file));
            writer = new StringWriter();

            char[] buffer = new char[1024];
            int read = reader.read(buffer, 0, 1024);

            while(read != -1)
            {
                writer.write(buffer, 0, read);
                read = reader.read(buffer, 0, 1024);
            }
            contents = writer.toString();
        }
        catch(Exception e)
        {
            throw new Exception ("Error reading file:" + file + e.getMessage());
        }
        finally
        {
            try
            {
                reader.close();
                writer.close();
            }
            catch (Exception e)
            {
            }
        }
        return contents;
    }

    private void parseArgs(String[] args) throws Exception
    {
        int i = 0;

        while(i < args.length)
        {
            if(args[i].equals("-url"))
            {
                m_url = args[++i];
            }
            else if(args[i].equals("-user"))
            {
                m_user = args[++i];
            }
            else if(args[i].equals("-password"))
            {
                m_password = args[++i];
            }
            else if(args[i].equals("-domain"))
            {
                m_domain = args[++i];
            }
            else if(args[i].equals("-importFiles"))
            {
                StringTokenizer strTok = new StringTokenizer(args[++i],",");
                while(strTok.hasMoreTokens())
                {
                    m_files.add(strTok.nextToken());
                }
            }
            i++;
        }
    }

    private static void printUsage()
    {
        System.out.println("com.sonicsw.mx.config.tools.admin.DSImporter ");
        System.out.println("    [-url brokerUrl]       (Default = " + DEFAULT_URL + ")");
        System.out.println("    [-user userName]       (Default = " + DEFAULT_USER + ")");
        System.out.println("    [-password password]   (Default = " + DEFAULT_PASSWORD + ")");
        System.out.println("    [-domain domainName]   (Default = " + DEFAULT_DOMAIN + ")");
        System.out.println("    [-importFiles filename1,filename2] ");
    }

    public static void main(String[] args)
    {
        DSImporter seeder = new DSImporter(args);

        System.exit(0);
    }
}