package com.sonicsw.mx.config.tools.admin;

import com.sonicsw.mx.config.ConfigServerUtility;

public class DirectoryExportUtility extends ConfigServerUtility
{
    private static final String DEFAULT_URL       = "localhost";
    private static final String DEFAULT_USER      = "Administrator";
    private static final String DEFAULT_PASSWORD  = "Administrator";        //NOSONAR field change is not required.
    private static final String DEFAULT_DOMAIN    = "Domain1";
    private static final String DEFAULT_OUTPUT    = "c:/temp";
    private static final String DEFAULT_SOURCE    = "/";

    private String m_url      = DEFAULT_URL;
    private String m_user     = DEFAULT_USER;
    private String m_password = DEFAULT_PASSWORD;           //NOSONAR field change is not required.
    private String m_domain   = DEFAULT_DOMAIN;
    private String m_output   = DEFAULT_OUTPUT;
    private String m_source   = DEFAULT_SOURCE;

    public DirectoryExportUtility(String [] args)
    {
        try
        {
            // Parse commandline arguments
            parseArgs(args);

            connect(m_domain, m_url, m_user, m_password, true);

            exportBeanPath(m_source, m_output);
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        finally
        {
            try { disconnect(); } catch(Exception e) { }
        }
    }

    private void parseArgs(String[] args) throws Exception
    {
        int i = 0;

        while(i < args.length)
        {
            if(args[i].equals("-url"))
            {
                m_url = args[++i];
            }
            else if(args[i].equals("-user"))
            {
                m_user = args[++i];
            }
            else if(args[i].equals("-password"))
            {
                m_password = args[++i];
            }
            else if(args[i].equals("-domain"))
            {
                m_domain = args[++i];
            }
            else if(args[i].equals("-output"))
            {
                m_output = args[++i];
            }
            else if(args[i].equals("-source"))
            {
                m_source = args[++i];
            }
            i++;
        }
    }

    private static void printUsage()
    {
        System.out.println("com.sonicsw.mx.config.tools.admin.DirectoryExportUtility ");
        System.out.println("    [-url brokerUrl]       (Default = " + DEFAULT_URL + ")");
        System.out.println("    [-user userName]       (Default = " + DEFAULT_USER + ")");
        System.out.println("    [-password password]   (Default = " + DEFAULT_PASSWORD + ")");
        System.out.println("    [-domain domainName]   (Default = " + DEFAULT_DOMAIN + ")");
        System.out.println("    [-output location]     (Default = " + DEFAULT_OUTPUT + ")");
        System.out.println("    [-source dsSource]     (Default = " + DEFAULT_SOURCE + ")");
    }

    public static void main(String[] args)
    {
        DirectoryExportUtility exporter = new DirectoryExportUtility(args);

        System.exit(0);
    }
}
