package com.sonicsw.mx.config.tools.admin;

import com.sonicsw.mx.config.ConfigServerUtility;

public class DirectoryImportUtility extends ConfigServerUtility
{
    private static final String DEFAULT_URL       = "localhost";
    private static final String DEFAULT_USER      = "Administrator";
    private static final String DEFAULT_PASSWORD  = "Administrator";    //NOSONAR field change is not required.
    private static final String DEFAULT_DOMAIN    = "Domain1";
    private static final String DEFAULT_INPUT     = "c:/temp";

    private String m_url      = DEFAULT_URL;
    private String m_user     = DEFAULT_USER;
    private String m_password = DEFAULT_PASSWORD;
    private String m_domain   = DEFAULT_DOMAIN;
    private String m_input    = DEFAULT_INPUT;

    public DirectoryImportUtility(String [] args)
    {
        try
        {
            parseArgs(args);

            connect(m_domain, m_url, m_user, m_password, true);

            importBeanPath(m_input, true);

            repairDanglingBeanReferences();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        finally
        {
            try { disconnect(); } catch(Exception e) { }
        }
    }

    private void parseArgs(String[] args) throws Exception
    {
        int i = 0;

        while(i < args.length)
        {
            if(args[i].equals("-url"))
            {
                m_url = args[++i];
            }
            else if(args[i].equals("-user"))
            {
                m_user = args[++i];
            }
            else if(args[i].equals("-password"))
            {
                m_password = args[++i];
            }
            else if(args[i].equals("-domain"))
            {
                m_domain = args[++i];
            }
            else if(args[i].equals("-input"))
            {
                m_input = args[++i];
            }
            i++;
        }
    }

    private static void printUsage()
    {
        System.out.println("com.sonicsw.mx.config.tools.admin.DirectoryImportUtility ");
        System.out.println("    [-url brokerUrl]       (Default = " + DEFAULT_URL + ")");
        System.out.println("    [-user userName]       (Default = " + DEFAULT_USER + ")");
        System.out.println("    [-password password]   (Default = " + DEFAULT_PASSWORD + ")");
        System.out.println("    [-domain domainName]   (Default = " + DEFAULT_DOMAIN + ")");
        System.out.println("    [-input location]      (Default = " + DEFAULT_INPUT + ")");
    }

    public static void main(String[] args)
    {
        DirectoryImportUtility exporter = new DirectoryImportUtility(args);

        System.exit(0);
    }
}
