/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.mx.config.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IConfigPath;


/**
 * Creates an iterator that iterates through the supplied IAttributeDescriptionMap
 * (IConfigType) returning a IConfigPath for each attribute description in the
 * type tree.
 */
public class AttributeDescriptionMapIterator implements Iterator
{
    private ArrayList list  = new ArrayList();
    private int       index = 0;


    public AttributeDescriptionMapIterator(IAttributeDescription map)
    {
        if (map == null)
        {
            throw new NullPointerException("AttributeDescription map can't be null.");
        }
        
        addNameSet(null, map.getAttributeDescriptionNames(), 0);
        
        int i = 0;

        while (i < list.size())
        {
            IConfigPath           path = (IConfigPath)list.get(i++);
            IAttributeDescription ad   = map.getAttributeDescription(path);

            if (ad == null)
            {
                continue;
            }

            addNameSet(path, ad.getAttributeDescriptionNames(), i);
        }
    }

    private void addNameSet(IConfigPath basePath, Set set, int insertPoint)
    {
        Iterator i = set.iterator();

        while (i.hasNext())
        {
            IConfigPath path = null;
            String newElement = (String)i.next();

            if (newElement.equals("mx.config.configTypeName"))
            {
                continue;
            }

            if (basePath == null)
            {
                path = ConfigFactory.createConfigPath(newElement);
            }
            else
            {
                path = ConfigFactory.createConfigPath(basePath).append(newElement);
            }

            if (path != null)
            {
                list.add(insertPoint, path);
            }
        }
    }

    @Override
    public boolean hasNext()
    {
        return (index < list.size());
    }

    @Override
    public Object next()
    {
        return list.get(index++);
    }

    @Override
    public void remove()
    {
        // not supported!!
    }

}
