/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.mx.config.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigPath;


/**
 * Creates an iterator that iterates through the supplied IAttributeMap
 * (IConfigBean) returning a IConfigPath for each attribute in the data tree.
 */
public class AttributeMapIterator implements Iterator
{
    private ArrayList list  = new ArrayList();
    private int       index = 0;


    public AttributeMapIterator(IAttributeMap map)
    {
        addNameSet(null, map.keySet(), 0);

        int i = 0;

        while (i < list.size())
        {
            IConfigPath           path = (IConfigPath)list.get(i++);
            Object      value = map.getAttribute(path);

            if (value instanceof IAttributeMap)
            {
                IAttributeMap child = (IAttributeMap)value;

                addNameSet(path, child.keySet(), i);
            }
            else
            if (value instanceof IAttributeList)
            {
                IAttributeList child = (IAttributeList)value;

                for (int listIndex = 0; listIndex < child.size(); listIndex++)
                {
                    IConfigPath aPath = null;

                    if (path == null)
                    {
                        aPath = ConfigFactory.createConfigPath(Integer.toString(listIndex));
                    }
                    else
                    {
                        aPath = ConfigFactory.createConfigPath(path).append(Integer.toString(listIndex));
                    }

                    if (aPath != null)
                    {
                        list.add(i, aPath);
                    }
                }
            }
        }
    }

    private void addNameSet(IConfigPath basePath, Set set, int insertPoint)
    {
        if ((set == null) || set.isEmpty())
        {
            return;
        }

        Iterator i = set.iterator();

        while (i.hasNext())
        {
            IConfigPath path = null;
            String newElement = (String)i.next();

            if (newElement.equals("mx.config.configTypeName"))
            {
                continue;
            }

            if (basePath == null)
            {
                path = ConfigFactory.createConfigPath(newElement);
            }
            else
            {
                path = ConfigFactory.createConfigPath(basePath).append(newElement);
            }

            if (path != null)
            {
                list.add(insertPoint, path);
            }
        }
    }

    @Override
    public boolean hasNext()
    {
        return (index < list.size());
    }

    @Override
    public Object next()
    {
        return list.get(index++);
    }

    @Override
    public void remove()
    {
        // not supported!!
    }

}
