package com.sonicsw.mx.config.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class MessageFormatter
{

    /**
     * Message Formatters.
     * A hash map containing messages formatters. Each message
     * formatter is associated with a single resource bundle
     * from which it retrieves the messages it formats. A message
     * formatter is identified in the hash map by the name of its
     * associated resource bundle and its locale.
     */
    protected static HashMap s_messageFormatters = new HashMap();

    /**
     * Message Formatter's Locale.
     * The locale used to format messages. may be null;
     */
    protected Locale m_locale = null;

    /**
     * Message Formatter's Resource Bundle.
     * The resource bundler associated with this message formatter.
     * The message formatter retrives from this bundle the messages that
     * it formats.
     */
    protected ResourceBundle m_resourceBundle = null;

    /**
     * Failed Load of Resource Bundle Indicator.
     * Indicates that the resource bundler could not be found and
     * loaded when this message formatter was constructed.
     */
    protected boolean m_loadFailed = false;

    public MessageFormatter(Locale locale, String resourceBaseName)
    {
        try
        {
            if (locale != null)
            {
                m_resourceBundle = PropertyResourceBundle.getBundle(resourceBaseName, locale);
                m_locale = locale;
            }
            if (m_resourceBundle == null)
            {
                m_resourceBundle = PropertyResourceBundle.getBundle(resourceBaseName);
            }
        }
        catch (MissingResourceException e)
        {
            e.printStackTrace();
            m_loadFailed = true;
        }
    }

    public String
    format(String key, Object[] arguments)
    {
        String msg = null;
        if (!m_loadFailed)
        {
            try
            {
                msg = m_resourceBundle.getString(key);
                if (arguments != null)
                {
                    try
                    {
                        msg = java.text.MessageFormat.format(msg, arguments);
                    }
                    catch (Exception e)
                    {   /* Formatting failed: keep msg null. */
                        e.printStackTrace();
                    }
                }
            }
            catch (MissingResourceException e)
            {   /* Bad key: keep message null. */
                //e.printStackTrace();
            }
        }

        if (msg == null)
        {   /*  Retrieval and/or formatting of message failed:
                build 'basic' message from key and arguments. */
            msg = key;
            if (arguments != null && arguments.length > 0)
            {
                StringBuffer str = new StringBuffer(msg);
                str.append('?');
                for (int i = 0; i < arguments.length; i++)
                {
                    if (i > 0)
                    {
                        str.append('&');
                    }
                    str.append(String.valueOf(arguments[i]));
                }
            }
        }

        return msg;
    }

    public static String
    formatMessage(String resourceBundle, String key, Object[] arguments)
    throws IllegalArgumentException
    {
        return formatMessage(null, resourceBundle, key, arguments);
    }

    public static String
    formatMessage(Locale locale, String resourceBundle, String key, Object[] arguments)
    throws IllegalArgumentException
    {
        if (resourceBundle == null)
        {
            return "";
        }

        if (key == null)
        {
            return "";
        }

        String bundleKey = null;
        if (locale == null)
        {
            bundleKey = resourceBundle;
        }
        else
        {
            bundleKey = resourceBundle + locale.toString();
        }

        MessageFormatter messageFormatter = (MessageFormatter) s_messageFormatters.get(bundleKey);
        if (messageFormatter == null)
        {
            messageFormatter = new com.sonicsw.mx.config.util.MessageFormatter(locale, resourceBundle);
            s_messageFormatters.put(bundleKey, messageFormatter);
        }
        return messageFormatter.format(key, arguments);
    }
}
