/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.mx.config.util;

/**
 * This class represents exceptions thrown by the SonicFSFileSystem. The
 * exception contains a string text message and optionally a linked Throwable
 * the contains the underlying exception that was the cause of the exception
 */
public class SonicFSException extends Exception
{
    /**
     * Create a SonicFSException with the specified String message
     */
    public SonicFSException(String msg)
    {
        super(msg);
    }

    /**
     * Create a SonicFSException with the specified String message and the
     * specified linked exception
     */
    public SonicFSException(String msg, Throwable linked)
    {
        super(msg, linked);
    }

    /**
     * Get the linked exception for this SonicFSException (if any).
     * @deprecated Use Exception.getCause() instead
     */
    public Throwable getLinkedException()
    {
        return getCause();
    }
}