package com.sonicsw.mx.config.util;

import java.util.Hashtable;

import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;

public class SonicFSTest
{
    private static final String TEST_FOLDER   = "/SonicFSTest";
    private static final String TEST_FILE1    = TEST_FOLDER + "/Test1.txt";
    private static final String TEST_CONTENT1 = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffff";
    private static final String TEST_CONTENT2 = "aaaaaaaaaa";

    private JMSConnectorClient m_connector = null;
    private SonicFSFileSystem  m_fs        = null;

    public SonicFSTest()
    {
        try
        {
            connect();

            m_fs.createDirectory(TEST_FOLDER);

            testListDetails();
            testUpdateFile();
            testListDetails();

            testList("/");
            testList("/Brokers");
            testListFolders("/");
            testListFolders("/Brokers");
            testListAllFolders();
            testListAllFolderDetails();
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
        finally
        {
            disconnect();
        }
    }

    public final void connect() throws Exception
    {
        String url      = "localhost";
        String domain   = "Domain1";
        String user     = "Administrator";
        String password = "Administrator";      //NOSONAR field change is not required.

        Hashtable env = new Hashtable();
        env.put("ConnectionURLs", url);
        env.put("DefaultUser", user);
        env.put("DefaultPassword", password);

        JMSConnectorAddress address = new JMSConnectorAddress(env);

        m_connector = new JMSConnectorClient();
        m_connector.connect(address);

        m_fs = new SonicFSFileSystem(m_connector, "foo", user);
    }

    public final void disconnect()
    {
        if (m_connector != null)
        {
            m_connector.disconnect();
        }
    }

    private void testListDetails() throws Exception
    {
        SonicFSFile[] details = m_fs.listDetails(TEST_FOLDER);

        System.out.println("Listing of '" + TEST_FOLDER + "' count = " + details.length);
        for(int i = 0; i < details.length; i++)
        {
            printDetails(details[i]);
        }
    }

    private void testList(String folder) throws Exception
    {
        System.out.println("list(" + folder + ")");
        String[] res = m_fs.list(folder);
        for (int i = 0; i < res.length; i++)
        {
            System.out.println("    " + res[i]);
        }
    }

    private void testListFolders(String folder) throws Exception
    {
        System.out.println("listFolders(" + folder + ")");
        String[] res = m_fs.listFolders(folder);
        for (int i = 0; i < res.length; i++)
        {
            System.out.println("    " + res[i]);
        }
    }

    private void testListAllFolders() throws Exception
    {
        System.out.println("listAllFolders()");
        String[] res = m_fs.listAllFolders();
        for (int i = 0; i < res.length; i++)
        {
            System.out.println("    " + res[i]);
        }
    }

    private void testListAllFolderDetails() throws Exception
    {
        System.out.println("listAllFolderDetails()");
        SonicFSFile[] res = m_fs.listAllFolderDetails();
        for (int i = 0; i < res.length; i++)
        {
            System.out.println("    " + res[i]);
        }
    }

    private void testCreateFile() throws Exception
    {
        m_fs.createFile(TEST_FILE1, TEST_CONTENT1);
    }

    private void testUpdateFile() throws Exception
    {
        m_fs.updateFile(TEST_FILE1, TEST_CONTENT2, true);
    }


/*
    private void printListing(String path) throws Exception
    {
        System.out.println("Calling list for '" + path + "'");
        String[] files = m_fs.list(path);
        for(int i = 0; i < files.length; i++)
            System.out.println("    " + files[i]);
    }

    private void printListingDetails(String path) throws Exception
    {
        System.out.println("Calling listDetails for '" + path + "'");
        SonicFSFile[] files = m_fs.listDetails(path);
        for(int i = 0; i < files.length; i++)
        {
            if(files[i].isDirectory())
                System.out.println("    Directory " + files[i].getName());
            else
                System.out.println("    File " + files[i].getName());
        }
    }
*/

    private void printDetails(SonicFSFile file)
    {
        System.out.println("File details:");

        if(file.isDirectory())
        {
            System.out.println("    Directory = " + file.isDirectory());
            System.out.println("    Name = " + file.getName());
            System.out.println("    Fullname = " + file.getFullName());
        }
        else
        {
            System.out.println("    Directory = " + file.isDirectory());
            System.out.println("    Name = " + file.getName());
            System.out.println("    Fullname = " + file.getFullName());
            System.out.println("    Size = " + file.getSize());
            System.out.println("    Creation Time = " + file.getCreationTimestamp());
            System.out.println("    Last Modified Time = " + file.getLastModified());
            System.out.println("    Created By = " + file.getCreatedBy());
        }
    }

    public static void main(String[] args)
    {
        new SonicFSTest();
    }
}