package com.sonicsw.mx.jndi;

import java.util.Properties;

import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;

/**
 *
 */
public final class MFNameParser implements NameParser
{
   public static class MFNameParserLazyLoader {
       private static final MFNameParser INSTANCE = new MFNameParser();
   }

   /** Naming syntax for name case sensitivity. Default value is case sensitive.*/
   private static final String JNDI_SYNTAX_IGNORECASE = "false";

   /**
    * Naming syntax for removing blank spaces in a Name. Default is to remove
    * the blank spaces.
    */
   private static final String JNDI_SYNTAX_TRIMBLANKS = "true";

   /**
    * Static Initialization for the Parser syntax values. It defines direction,
    * seperator,ignorecase and trimblanks values.
    * @link {javax.naming.NamingParser}
    */

   private static final Properties  PARSER_SYNTAX_PROPERTIES = new Properties();

   static
   {
      PARSER_SYNTAX_PROPERTIES.put("jndi.syntax.direction", "left_to_right");
      PARSER_SYNTAX_PROPERTIES.put("jndi.syntax.separator", "/");
      PARSER_SYNTAX_PROPERTIES.put(JNDI_SYNTAX_IGNORECASE, "false");
      PARSER_SYNTAX_PROPERTIES.put(JNDI_SYNTAX_TRIMBLANKS, "true");
   }

   public MFNameParser()
   {
   }

   /**
    * Parses a name into its components by returning a CompoundName object.
    * <p>
    * @param string Input string specifing the Name.
    * @return javax.naming.CompoundName Name object
    * @throws NamingException If the Name object cannot be parsed or created.
    */
    @Override
    public javax.naming.Name parse(String string) throws NamingException
    {
        return new CompoundName(string, PARSER_SYNTAX_PROPERTIES);
    }

    public static final MFNameParser getInstance()
    {
        return MFNameParserLazyLoader.INSTANCE;
    }

    public String convertToString(Name name)
    {
       return name.toString();
    }
}