package com.sonicsw.sdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

//Integrates MF component tracing into the SDF
public abstract class AbstractMFComponentTracing extends AbstractDiagnosticsProvider
{
    private static final String NO_TRACING_TEXT = "no tracing";
    private String[] OPERATIONS;
    private HashMap DESCRIBE_PARAM_DESCIPTOR;
    private HashMap UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR;
    private HashMap SHOW_TRACE_LEVEL_PARAM_DESCIPTOR;
    private HashMap PARAM_DESCRIPTOR ;

    private HashMap m_nameToIntMap;
    private String m_maskNameStringMap;
    private Integer m_currentMask;
    private String m_diagSubsysName;


    public AbstractMFComponentTracing(String diagSubsysName, String maskNameToIntMap0)
    {
        super(diagSubsysName);
        m_diagSubsysName = diagSubsysName;


        setMaskNamesMap(maskNameToIntMap0);
        m_currentMask = new Integer(0);

        DESCRIBE_PARAM_DESCIPTOR = new HashMap();
        UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
        SHOW_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
        PARAM_DESCRIPTOR = new HashMap();

        UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put(INTEGER_TRACE_LEVEL_PARAM, "An integer mask. See the " + STRING_TRACE_LEVEL_PARAM + " parameter for the optional values");
        UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put(STRING_TRACE_LEVEL_PARAM, "A comma separated list of mask names from the following list: " + m_maskNameStringMap);


        PARAM_DESCRIPTOR.put(DESCRIBE_OP, DESCRIBE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put(UPDATE_TRACE_LEVEL_OP, UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put(SHOW_TRACE_LEVEL_OP, SHOW_TRACE_LEVEL_PARAM_DESCIPTOR);

        OPERATIONS = toOpnameArray(PARAM_DESCRIPTOR);
    }

    public Integer getIntegerMask(String nameMask, StringBuffer buffer)
    {
        if (nameMask == null)
        {
            return new Integer(0);
        }

        int intMask = 0;
        StringTokenizer masks = new StringTokenizer(nameMask, ",");

        while (masks.hasMoreElements())
        {
            String maskName = (String)masks.nextToken();
            Integer maskIntValue = (Integer)m_nameToIntMap.get(maskName);
            if (maskIntValue == null)
            {
                buffer.append("'" + maskName + "' is invalid - ignored").append(NEWLINE);
                continue;
            }
            else
            {
                intMask += maskIntValue.intValue();
            }
        }

        return new Integer(intMask);
    }

    @Override
    public String[] getOperations()
    {
       return OPERATIONS;
    }

    @Override
    public HashMap describeParameters(String operationName)
    {
        return (HashMap)PARAM_DESCRIPTOR.get(operationName);
    }


    @Override
    public String describe()
    {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Provides trace level setup. Examples:").append(NEWLINE);
        buffer.append(m_diagSubsysName).append(" updateTraceLevel " + STRING_TRACE_LEVEL_PARAM + "=verbose,operation_invoked").append(NEWLINE);
        buffer.append(m_diagSubsysName).append(" updateTraceLevel " + INTEGER_TRACE_LEVEL_PARAM + "=5").append(NEWLINE);
        return buffer.toString();
    }

    @Override
    public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer)
    {
        String stringTraceLevel = (String)parameters.get(STRING_TRACE_LEVEL_PARAM);
        String intTraceLevel = (String)parameters.get(INTEGER_TRACE_LEVEL_PARAM);

        if (stringTraceLevel != null && intTraceLevel != null)
        {
            buffer.append("Cannot set both " + STRING_TRACE_LEVEL_PARAM + " and " + INTEGER_TRACE_LEVEL_PARAM);
            return;
        }

        if (stringTraceLevel == null && intTraceLevel == null)
        {
            buffer.append("Both " + STRING_TRACE_LEVEL_PARAM + " and " + INTEGER_TRACE_LEVEL_PARAM + " were not set; trace level is unchaged - ");

            buffer.append(getCurrentMaskNames());

            return;
        }

        if (stringTraceLevel != null)
        {
            setTraceMask(stringTraceLevel, buffer);
        }
        else
        {
            Integer mask = null;
            try
            {
                 mask = new Integer(Integer.parseInt (intTraceLevel));
            }
            catch (Exception e)
            {
                buffer.append("Bad value of " + INTEGER_TRACE_LEVEL_PARAM);
                buffer.append(": " + e.toString());
                buffer.append(" - trace level is unchanged");
                return;
            }
            setTraceMask(mask);
        }


        buffer.append("The new trace level is: " + getCurrentMaskNames());

    }

    @Override
    public void showTraceLevel(String doiID, HashMap parameters, StringBuffer buffer)
    {
        buffer.append("The trace level is: "  + getCurrentMaskNames());
    }

    public final void setTraceMask(Integer mask)
    {
        m_currentMask = mask;
    }

    private void setTraceMask(String maksNames, StringBuffer buffer)
    {
        setTraceMask(getIntegerMask(maksNames, buffer));
    }

    protected Integer getCurrentMask()
    {
        return m_currentMask;
    }

    protected String getCurrentMaskNames()
    {
        int mask = m_currentMask.intValue();
        ArrayList nameList = new ArrayList();

        Iterator maskExtries = m_nameToIntMap.entrySet().iterator();

        while (maskExtries.hasNext())
        {
            Map.Entry entry = (Map.Entry)maskExtries.next();
            String maskName = (String)entry.getKey();
            Integer maskInt = (Integer)entry.getValue();
            if ((mask & maskInt.intValue()) != 0)
            {
                nameList.add(maskInt.toString() + "=" + maskName);
            }
        }

        StringBuffer maskNames = new StringBuffer();
        int listSize = nameList.size();
        for (int i = 0; i < listSize; i++)
        {
            maskNames.append((String)nameList.get(i));
            if (i+1 < listSize)
            {
                maskNames.append(",");
            }
        }
        if (maskNames.length() == 0)
        {
            return NO_TRACING_TEXT;
        }
        else
        {
            return "'" + maskNames.toString() + "'";
        }
    }

    private void setMaskNamesMap(String stringMap)
    {
        StringBuffer correctedStringMap = new StringBuffer();
        if (stringMap == null)
        {
            m_maskNameStringMap = "";
            m_nameToIntMap = new HashMap();
            return;
        }

        StringTokenizer maskItems = new StringTokenizer(stringMap, ",");

        HashMap nameToIntMap = new HashMap();

        while (maskItems.hasMoreElements())
        {
            String maskItem = (String)maskItems.nextToken();
            int valueIndex = maskItem.indexOf("=");

            if (valueIndex != -1)
            {
                Integer maskInt = null;
                try
                {
                    maskInt = new Integer(maskItem.substring(0, valueIndex));
                }
                catch (Exception e)
                {
                    continue;
                }

                String maskName = maskItem.substring(valueIndex+1).replace(' ', '_');

                nameToIntMap.put(maskName, maskInt);
                if (correctedStringMap.length() > 0)
                {
                    correctedStringMap.append(",");
                }
                correctedStringMap.append(maskInt.toString() + '=' + maskName);
            }
            else
            {
                continue;
            }
        }
        m_maskNameStringMap = correctedStringMap.toString();
        m_nameToIntMap = nameToIntMap;

    }


}



