package com.sonicsw.sdf;

public class  DiagnosticsManagerAccess
{
    private static Object m_lock = new Object();

    private static IDiagnosticsManager m_manager; // Refernce the framework singleton

   /**
    * Can be used from any code running in the container (or other modules that supports the SDF) to get IDiagnosticsManager. IDiagnosticsManager
    * and DiagnosticsManagerAccess are loaded by the global class loader. Use primarily to register IDiagnosticsProvider objects.
    *
    * @return the Diagnostics Manager.
    */
    public static IDiagnosticsManager getManager()
    {
        return m_manager;
    }

   /**
    * Creates a new DiagnosticsManager or return the existing one.
    * Called from com.sonicsw.mf.framework.agent.ContainerImpl and
    * progress.message.jclient.ConnectionFactory (for MQ clients)
    */
    public static IDiagnosticsManager createManager()
    {
        synchronized (m_lock)
        {
            if (m_manager != null)
            {
                return m_manager;
            }
            else
            {
                m_manager = new com.sonicsw.sdf.impl.DiagnosticsManager();
                return m_manager;
            }
        }
    }
    
   /**
    * Used in modules where the SDF was not created to allow the same diagnostics code to run without checking for null references
    *
    * @param diagnosedSystem the diagnostics system we could not register
    *
    * @return context for creating trace files, dump files and history tracking objects
    */
    public static IDiagnosticsContext createContext(IDiagnosticsProvider diagnosedSystem)
    {
        return com.sonicsw.sdf.impl.DiagnosticsManager.createContext(diagnosedSystem);

    }

}

