package com.sonicsw.sdf;

public interface IDiagnosticsConstants
{
    String NEWLINE = System.getProperty("line.separator");

    //System Properties
    String INSTRUCTIONS_FILE_SEARCH_FREQUENCY_SYSPROP = "SonicDiagnosticsFileFrequency";
    String INSTRUCTIONS_FILE_SEARCH_FREQUENCY_SYSPROP_DEPRECATED = "DiagnosticsInstructionsFileFrequency";
    String ENABLE_DIAGNOSTICS_TESTS_SYSPROP = "SonicDiagnosticsEnableTests";
    int INSTRUCTIONS_FILE_SEARCH_FREQUENCY_DFLT = 10; //Seconds
    int INSTRUCTIONS_FILE_SEARCH_FREQUENCY_MAX = 10; //Seconds
    int INSTRUCTIONS_FILE_SEARCH_FREQUENCY_MIN = 3; //Seconds
    String DIAGNOSTICS_INSTRUCTIONS_FILE_PATH_SYSPROP =  "SonicDiagnosticsFile";

    //Default IO files
    String DIAGNOSTICS_INSTRUCTIONS_FILE_NAME_DFLT = "SonicDiagnostics.txt";
    String CONTAINER_SHUTDOWN_FILE_NAME = "shutdown_sonic_container";
    String DIAGNOSTICS_STATUS_FILE_NAME = "SonicDiagnostics.status";

    //Operations
    String UPDATE_TRACE_LEVEL_OP = "updateTraceLevel";
    String SHOW_TRACE_LEVEL_OP = "showTraceLevel";
    String DUMP_STATE_OP = "dumpState";
    String TEST_OP = "test";
    String SETUP_OP = "setup";
    String DESCRIBE_OP = "describe";
    String DESCRIBE_ALL_OP = "describeAll";
    String LISTALL_OP = "listAll";
    String LIST_DIAGNOSTICS_INSTANCES_OP = "listDiagnosticsInstances";
    String HELP_OP = "help";
    String HELP1_OP = "h";
    String HELP2_OP = "?";


    //Well known Subsystems
    String SONIC_DIAGNOSTICS_SUBSYS = "sonic.diagnostics";
    String JVM_THREADS_SUBSYS = "jvm.threads";
    String JVM_HEAP_SUBSYS = "jvm.heap";

    //Parameters
    String SUBSYSTEM_ID_PARAM = "subsystemID";
    String STATUS_FILE_DEFAULT_PARAM = "statusFilePath";
    String FILTER_TAGS_PARAM = "filterTags";
    String DIAGNOSTICS_OBJECT_ID_PARAM = "doiID";
    String STRING_TRACE_LEVEL_PARAM = "stringTraceLevel";
    String INTEGER_TRACE_LEVEL_PARAM = "integerTraceLevel";
    String PROCESS_COUNT_PARAM = "processInstructionsFileCount";

    //Wild card processing
    String WILDE_CARD_STRING = "*";
    String WILD_CARD_ERROR_MESSAGE = "Wildcard format is: 'a.b.c.*' or '*' - the '*' chracter must be the only or last component";
    char COMPONENT_SEPERATOR_CHAR = '.';

    //Misc
    long  NO_LIMIT_TRACE_FILE_SIZE = -1;
    String COMMA_STRING = ",";
    String STATE_FILE_POSTFIX = ".state";
    String TRACE_FILE_POSTFIX = ".trace";
    String START_TIMESTAMP_FILE = "start_timestamp";

    //Standard state dump headers
    String HEADERNAME_CONTAINER = "Container";
    String HEADERNAME_INSTRUCTION = "Instruction";
    String HEADERNAME_STARTTIME = "Dump start time";
    String HEADERNAME_ENDTIME = "Dump end time";
    String HEADERNAME_HOST = "Host";
    String HEADERNAME_OPERATING_SYS = "Operating System";
    String HEADERNAME_JVM = "Java VM";
    String HEADERNAME_START_TIME = "Started";
    String HEADERNAME_PROCESSOR_COUNT = "Available Processors";
    String HEADERNAME_AVERAGE_LOAD = "Average load (over last minute)";

}
