package com.sonicsw.sdf;


/**
 * IDiagnosticsHistoryTracker is obtained from IDiagnosticsContext.createHistoryTrackerObject(). It is used by the IDiagnosticsProvider object for
 * tracking the state changes of the IDiagnosticsProvider object and then dump the text representation of the state into an IStateWriter file when the dumpState
 * operation is called.
 */
public interface IDiagnosticsHistoryTracker
{
 /**
  * Returns the next history item to be filled with state information by the caller. getHistoryItem() reuses item from the array passed to it
  * in the IDiagnosticsContext.createHistoryTrackerObject() call
  *
  * @return the next history item.
  */
  public Object getHistoryItem();

 /**
  * The IDiagnosticsHistoryTracker object appends the text representation of the history it contains into the buffer
  *
  *
  * @param buffer used by IDiagnosticsHistoryTracker to append its text representation into
  */
  public void appendHistory(StringBuffer buffer);

}

