package com.sonicsw.sdf;

import java.util.HashMap;

 /**
  * IDiagnosticsManager is a singleton created by the MF container (or other modules that use the SDF). IDiagnosticsManager.register() is the most typically used
  * method of IDiagnosticsManager. IDiagnosticsManager is obtained from DiagnosticsManagerAccess.getManager().
  */
public interface IDiagnosticsManager extends IDiagnosticsConstants
{
 /**
  * Registers an IDiagnosticsProvider object. Each MF container (or any other diagnosed module) should not typically contain more than
  * a thousand of registered subsystems. Finer granularity is achieved using the DOI (Diagnostics Object Instance) mechanism; see IDiagnosticsProvider.
  *
  * @param diagnosedSystem an instance of an IDiagnosticsProvider class. Typically extends com.sonicsw.sdf.AbstractDiagnosticsProvider
  *
  * @return context for the registered object to obtain a logger and IDiagnosticsHistoryTracker objects
  */
  public IDiagnosticsContext register(IDiagnosticsProvider diagnosedSystem);

 /**
  * Executes an operation in a registered IDiagnosticsProvider object and append execution status to the StringBuffer buffer. Ths use of
  * wild cards in subsystemName can result in the execution of opName in multiple IDiagnosticsProvider objects. Wild card cannot be used if specific
  * instances are addressed with subsystemID and/or doiID are not null.
  *
  * @param opName operations such as dumpState updateTraceLevel etc.
  * @param subsystemName the name of the registered subsystem  - the last component of the name can contain a '*' wild card.
  * @param tags if any tag is specified then
  * @param subsystemID used when multiple instances of subsystemName are registered. Can be null.
  * @param doiID IDiagnosticsProvider implementations can be written to control multiple  Diagnostics Objects Instaces (doi). If it's desirable
  *              to dump the state or trace only one of those objects rather than the entire subsystem then doiID can be specified, otherwise doiID
  *              could be null.
  * @param buffer any status, error or information text resulting from executing the operation will be appended to the text in this buffer
  * @param parameters some operations, such as updateTraceLevel, require parameters
  *
  */
  public void executeOperation (String opName, String subsystemName, String[] tags, String subsystemID, String doiID, StringBuffer buffer, HashMap parameters);

 /**
  * Executes an operation in a registered IDiagnosticsProvider object and append execution status to the StringBuffer buffer. Ths use of
  * wild cards in subsystemName can result in the execution of opName in multiple IDiagnosticsProvider objects. This method can be used with simple
  * diagnostics subsystems which don't have multiple instances (subsystemID is null), no doi objects (doiID is null) and no tags need to be used.
  *
  * @param opName operations such as dumpState updateTraceLevel etc.
  * @param subsystemName the name of the registered subsystem  - the last component of the name can contain a '*' wild card.
  * @param buffer any status, error or information text resulting from executing the operation will be appended to the text in this buffer
  * @param parameters some operations, such as updateTraceLevel, require parameters
  *
  */
  public void executeOperation (String opName, String subsystemName, StringBuffer buffer, HashMap parameters);

 /**
  * Returns a table cobtaining all the registered diagnostics subsystems.
  *
  * @return each key in the HashMap ia name of a registered IDiagnosticsProvider object. If the same subsystem contains multiple instances then the
  *         HashMap value is a String array with subsystemID values - one for each registered instance
  */
  public HashMap getRegistrationList();

 /**
  * Executes one or more new-line seperated list of diagnostics instructions
  *
  * @param diagnosticsInstructionsString the instructions
  *
  * @return the status of the execution
  */
  public String executeDiagnosticsInstructions(String diagnosticsInstructionsString);

 /**
  * Set a shutdown interface
  *
  * @param shutdownInterface
  *
  */
  public void setShutdownInterface(IShutdown shutdownInterface);
  
  /**
   * If the IDiagnosticsManager is used in the context of an MF container
   * (or another module where a similar 'name' is available) it should be
   * given to the IDiagnosticsManager so it can be included in diagnostic
   * output.
   */
  public void setContainerName(String containerName);
  
  /**
   * Returns the container name if available, else null.
   */
  public String getContainerName();

}
