package com.sonicsw.sdf;

import java.io.IOException;

/**
 * IStateWriter is obtained from IDiagnosticsContext.getStateWriter() by the IDiagnosticsProvider object. It is used for dumping the text representing
 * the state of the IDiagnosticsProvider object into a file when the dumpState operation is called.
 *
 */
public interface IStateWriter
{
    /**
     * Writes text representing a portion of the IDiagnosticsProvider object.
     * write() will be typically called multiple times until the entire state
     * of the IDiagnosticsProvider object is dumped.
     *
     * @param state text representing the state of the IDiagnosticsProvider object
     *
     * @exception IOException if the write failed
     */
    public void write(String state) throws IOException;

    /**
     * Same as write() except that it adds a carriage return to the end
     * of the state string.
     * 
     * @param state text representing the state of the IDiagnosticsProvider object
     * @throws IOException if the write failed
     */
    public void writeln(String state) throws IOException;

    /**
     * Writes a blank line.
     * 
     * @throws IOException if the write failed
     */
    public void writeln() throws IOException;

    /**
     * Returns the path of this file
     *
     * @return returns the path of this file
     */
    public String getFilePath();

    /**
     * Closes this file. Should be called after dumping the entire state of the IDiagnosticsProvider object
     */
    public void close();

}